/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.interactivechat;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.interactivechat.InteractiveChatIntegration;
import net.flectone.pulse.module.integration.interactivechat.listener.InteractiveChatPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class InteractiveChatModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final InteractiveChatIntegration interactiveChatIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.interactiveChatIntegration.hook();
        this.listenerRegistry.register(InteractiveChatIntegration.class);
        this.listenerRegistry.register(InteractiveChatPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.interactiveChatIntegration.unhook();
    }

    @Override
    public Integration.Interactivechat config() {
        return this.fileResolver.getIntegration().getInteractivechat();
    }

    @Override
    public Permission.Integration.Interactivechat permission() {
        return this.fileResolver.getPermission().getIntegration().getInteractivechat();
    }

    public String checkMention(FEntity fSender, String message) {
        if (this.isModuleDisabledFor(fSender)) {
            return message;
        }
        return this.interactiveChatIntegration.checkMention(fSender, message);
    }

    public boolean sendMessage(FEntity fReceiver, Component message) {
        if (this.isModuleDisabledFor(fReceiver)) {
            return false;
        }
        return this.interactiveChatIntegration.sendMessage(fReceiver, message);
    }

    @Inject
    @Generated
    public InteractiveChatModule(FileResolver fileResolver, InteractiveChatIntegration interactiveChatIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.interactiveChatIntegration = interactiveChatIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

