/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.itemsadder;

import dev.lone.itemsadder.api.FontImages.FontImageWrapper;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

@Singleton
public class ItemsAdderIntegration
implements FIntegration,
PulseListener {
    private final FLogger fLogger;
    private boolean hooked;

    @Override
    public void hook() {
        this.hooked = true;
        this.fLogger.info("\u2714 ItemsAdder hooked");
    }

    @Override
    public void unhook() {
        this.hooked = false;
        this.fLogger.info("\u2716 ItemsAdder unhooked");
    }

    @Pulse(priority=Event.Priority.LOW)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        if (!this.isHooked()) {
            return;
        }
        FEntity fPlayer = messageContext.getSender();
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return;
        }
        String message = FontImageWrapper.replaceFontImages((Permissible)player, (String)messageContext.getMessage());
        messageContext.setMessage(message);
    }

    @Inject
    @Generated
    public ItemsAdderIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Generated
    public boolean isHooked() {
        return this.hooked;
    }
}

