/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.libertybans;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.logging.FLogger;
import space.arim.libertybans.api.LibertyBans;
import space.arim.libertybans.api.Operator;
import space.arim.libertybans.api.PlayerOperator;
import space.arim.libertybans.api.PunishmentType;
import space.arim.libertybans.api.punish.Punishment;
import space.arim.libertybans.api.select.SelectionByApplicability;
import space.arim.libertybans.api.select.SelectionByApplicabilityBuilder;
import space.arim.omnibus.Omnibus;
import space.arim.omnibus.OmnibusProvider;

@Singleton
public class LibertyBansIntegration
implements FIntegration {
    private final FLogger fLogger;
    private final FPlayerService fPlayerService;
    private LibertyBans libertyBans;

    @Override
    public void hook() {
        Omnibus omnibus = OmnibusProvider.getOmnibus();
        Optional optionalLibertyBans = omnibus.getRegistry().getProvider(LibertyBans.class);
        if (optionalLibertyBans.isEmpty()) {
            return;
        }
        this.libertyBans = (LibertyBans)optionalLibertyBans.get();
        this.fLogger.info("\u2714 LibertyBans hooked");
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 LibertyBans unhooked");
    }

    public boolean isHooked() {
        return this.libertyBans != null;
    }

    public boolean isMuted(FEntity fEntity) {
        return this.selectMute(fEntity).isPresent();
    }

    public ExternalModeration getMute(FEntity fEntity) {
        FPlayer fPlayer;
        Optional<Punishment> optionalPunishment = this.selectMute(fEntity);
        if (optionalPunishment.isEmpty()) {
            return null;
        }
        Punishment punishment = optionalPunishment.get();
        Operator operator = punishment.getOperator();
        if (operator instanceof PlayerOperator) {
            PlayerOperator playerOperator = (PlayerOperator)operator;
            fPlayer = this.fPlayerService.getFPlayer(playerOperator.getUUID());
        } else {
            fPlayer = this.fPlayerService.getConsole();
        }
        FPlayer operator2 = fPlayer;
        return new ExternalModeration(fEntity.getName(), operator2.getName(), punishment.getReason(), punishment.getIdentifier(), punishment.getStartDate().toEpochMilli(), punishment.isPermanent() ? -1L : punishment.getEndDate().toEpochMilli(), punishment.isPermanent());
    }

    private Optional<Punishment> selectMute(FEntity fEntity) {
        FPlayer fPlayer;
        block5: {
            block4: {
                if (!(fEntity instanceof FPlayer)) break block4;
                fPlayer = (FPlayer)fEntity;
                if (this.isHooked()) break block5;
            }
            return Optional.empty();
        }
        try {
            UUID uuid = fPlayer.getUuid();
            InetAddress ip = InetAddress.getByName(fPlayer.getIp());
            return (Optional)((SelectionByApplicability)((SelectionByApplicabilityBuilder)this.libertyBans.getSelector().selectionByApplicabilityBuilder(uuid, ip).type(PunishmentType.MUTE)).build()).getFirstSpecificPunishment().toCompletableFuture().join();
        }
        catch (UnknownHostException e) {
            return Optional.empty();
        }
    }

    @Inject
    @Generated
    public LibertyBansIntegration(FLogger fLogger, FPlayerService fPlayerService) {
        this.fLogger = fLogger;
        this.fPlayerService = fPlayerService;
    }
}

