/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.libertybans;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.libertybans.LibertyBansIntegration;
import net.flectone.pulse.module.integration.libertybans.listener.LibertyBansPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class LibertyBansModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final LibertyBansIntegration libertyBansIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.libertyBansIntegration.hook();
        this.listenerRegistry.register(LibertyBansPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.libertyBansIntegration.unhook();
    }

    @Override
    public Integration.Libertybans config() {
        return this.fileResolver.getIntegration().getLibertybans();
    }

    @Override
    public Permission.Integration.Libertybans permission() {
        return this.fileResolver.getPermission().getIntegration().getLibertybans();
    }

    public boolean isMuted(FEntity fEntity) {
        if (this.isModuleDisabledFor(fEntity)) {
            return false;
        }
        return this.libertyBansIntegration.isMuted(fEntity);
    }

    public ExternalModeration getMute(FEntity fEntity) {
        if (this.isModuleDisabledFor(fEntity)) {
            return null;
        }
        return this.libertyBansIntegration.getMute(fEntity);
    }

    public boolean isHooked() {
        return this.libertyBansIntegration.isHooked();
    }

    @Inject
    @Generated
    public LibertyBansModule(FileResolver fileResolver, LibertyBansIntegration libertyBansIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.libertyBansIntegration = libertyBansIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

