/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.libertybans.listener;

import java.util.Set;
import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.module.ModuleEnableEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.command.ban.BanModule;
import net.flectone.pulse.module.command.banlist.BanlistModule;
import net.flectone.pulse.module.command.kick.KickModule;
import net.flectone.pulse.module.command.mute.MuteModule;
import net.flectone.pulse.module.command.mutelist.MutelistModule;
import net.flectone.pulse.module.command.unban.UnbanModule;
import net.flectone.pulse.module.command.unmute.UnmuteModule;
import net.flectone.pulse.module.command.unwarn.UnwarnModule;
import net.flectone.pulse.module.command.warn.WarnModule;
import net.flectone.pulse.module.command.warnlist.WarnlistModule;
import net.flectone.pulse.module.integration.libertybans.LibertyBansModule;

@Singleton
public class LibertyBansPulseListener
implements PulseListener {
    private final Set<Class<? extends AbstractModule>> banModules = Set.of(BanModule.class, BanlistModule.class, UnbanModule.class);
    private final Set<Class<? extends AbstractModule>> muteModules = Set.of(MuteModule.class, MutelistModule.class, UnmuteModule.class);
    private final Set<Class<? extends AbstractModule>> warnModules = Set.of(WarnModule.class, WarnlistModule.class, UnwarnModule.class);
    private final Set<Class<? extends AbstractModule>> kickModules = Set.of(KickModule.class);
    private final LibertyBansModule libertyBansModule;

    @Pulse
    public void onModuleEnableEvent(ModuleEnableEvent event) {
        if (!this.libertyBansModule.isHooked()) {
            return;
        }
        AbstractModule eventModule = event.getModule();
        Integration.Libertybans config = this.libertyBansModule.config();
        if (config.isDisableFlectonepulseBan() && this.isInstanceOfAny(eventModule, this.banModules) || config.isDisableFlectonepulseMute() && this.isInstanceOfAny(eventModule, this.muteModules) || config.isDisableFlectonepulseWarn() && this.isInstanceOfAny(eventModule, this.warnModules) || config.isDisableFlectonepulseKick() && this.isInstanceOfAny(eventModule, this.kickModules)) {
            event.setCancelled(true);
        }
    }

    private boolean isInstanceOfAny(AbstractModule module, Set<Class<? extends AbstractModule>> classes) {
        return classes.stream().anyMatch(clazz -> clazz.isInstance(module));
    }

    @Inject
    @Generated
    public LibertyBansPulseListener(LibertyBansModule libertyBansModule) {
        this.libertyBansModule = libertyBansModule;
    }
}

