/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.miniplaceholders;

import io.github.miniplaceholders.api.MiniPlaceholders;
import io.github.miniplaceholders.api.types.RelationalAudience;
import java.util.HashSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MiniPlaceholdersIntegration
implements FIntegration,
PulseListener {
    private final Pattern bracesPattern = Pattern.compile("\\{([^}]*)}");
    private final FLogger fLogger;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public MiniPlaceholdersIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Override
    public void hook() {
        this.fLogger.info("\u2714 MiniPlaceholders hooked");
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 MiniPlaceholders unhooked");
    }

    @Pulse(priority=Event.Priority.HIGH)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        HashSet<TagResolver> resolvers = new HashSet<TagResolver>();
        resolvers.add(MiniPlaceholders.globalPlaceholders());
        Audience sender = this.getAudienceOrDefault(messageContext.getSender().getUuid(), null);
        Audience receiver = null;
        if (sender != null) {
            receiver = this.getAudienceOrDefault(messageContext.getReceiver().getUuid(), sender);
            resolvers.add(MiniPlaceholders.audiencePlaceholders());
            resolvers.add(MiniPlaceholders.relationalPlaceholders());
        }
        TagResolver[] resolversArray = resolvers.toArray(new TagResolver[0]);
        String message = this.replaceMiniPlaceholders(messageContext.getMessage(), resolversArray, sender, receiver);
        messageContext.setMessage(message);
    }

    private Audience getAudienceOrDefault(UUID uuid, Audience defaultAudience) {
        Player audience = Bukkit.getPlayer((UUID)uuid);
        return audience == null ? defaultAudience : audience;
    }

    private String replaceMiniPlaceholders(String text, TagResolver[] resolvers, Audience sender, Audience receiver) {
        Matcher matcher = this.bracesPattern.matcher(text);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String content = matcher.group(1);
            Component parsedMessage = sender == null || receiver == null ? this.miniMessage.deserialize(content, resolvers) : this.miniMessage.deserialize(content, (Pointered)new RelationalAudience(sender, receiver), resolvers);
            matcher.appendReplacement(result, ((String)this.miniMessage.serialize(parsedMessage)).replaceAll("</#[0-9a-fA-F]+>", ""));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

