/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.miniplaceholders;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.miniplaceholders.MiniPlaceholdersIntegration;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class MiniPlaceholdersModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final MiniPlaceholdersIntegration miniPlaceholdersIntegration;
    private final ListenerRegistry listenerRegistry;

    @Inject
    public MiniPlaceholdersModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, FLogger fLogger) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.miniPlaceholdersIntegration = new MiniPlaceholdersIntegration(fLogger);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getUse());
        this.miniPlaceholdersIntegration.hook();
        this.listenerRegistry.register(MessageFormattingEvent.class, Event.Priority.HIGH, event -> {
            MessageFormattingEvent messageFormattingEvent = (MessageFormattingEvent)event;
            MessageContext messageContext = messageFormattingEvent.getContext();
            FEntity sender = messageContext.getSender();
            if (this.isModuleDisabledFor(sender)) {
                return;
            }
            this.miniPlaceholdersIntegration.onMessageFormattingEvent(messageFormattingEvent);
        });
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.miniPlaceholdersIntegration.unhook();
    }

    @Override
    public Integration.MiniPlaceholders config() {
        return this.fileResolver.getIntegration().getMiniplaceholders();
    }

    @Override
    public Permission.Integration.MiniPlaceholders permission() {
        return this.fileResolver.getPermission().getIntegration().getMiniplaceholders();
    }
}

