/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.motd;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.motd.MOTDIntegration;
import net.flectone.pulse.module.integration.motd.listener.MOTDPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class MOTDModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final MOTDIntegration motdIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.motdIntegration.hook();
        this.listenerRegistry.register(MOTDPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.motdIntegration.unhook();
    }

    @Override
    public Integration.MOTD config() {
        return this.fileResolver.getIntegration().getMotd();
    }

    @Override
    public Permission.Integration.MOTD permission() {
        return this.fileResolver.getPermission().getIntegration().getMotd();
    }

    public boolean isHooked() {
        return this.motdIntegration.isHooked();
    }

    @Inject
    @Generated
    public MOTDModule(FileResolver fileResolver, MOTDIntegration motdIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.motdIntegration = motdIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

