/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.skinsrestorer;

import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.adventure.text.object.PlayerHeadObjectContents;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.logging.FLogger;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.SkinsRestorer;
import net.skinsrestorer.api.SkinsRestorerProvider;
import net.skinsrestorer.api.event.SkinApplyEvent;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;

@Singleton
public class SkinsRestorerIntegration
implements FIntegration {
    private final FlectonePulse flectonePulse;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final Provider<SkinService> skinServiceProvider;
    private final FLogger fLogger;
    private SkinsRestorer skinsRestorer;
    private boolean skinApplyEventSubscribed;

    @Override
    public void hook() {
        try {
            this.skinsRestorer = SkinsRestorerProvider.get();
            if (!this.skinApplyEventSubscribed) {
                this.skinsRestorer.getEventBus().subscribe((Object)this.flectonePulse, SkinApplyEvent.class, event -> {
                    UUID uuid = this.platformPlayerAdapter.getUUID(event.getPlayer(this.platformPlayerAdapter.getPlayerClass()));
                    if (uuid == null) {
                        return;
                    }
                    ((SkinService)this.skinServiceProvider.get()).updateProfilePropertyCache(uuid, this.convertToProfileProperty(event.getProperty()));
                });
                this.skinApplyEventSubscribed = true;
            }
            this.fLogger.info("\u2714 SkinsRestorer hooked");
        }
        catch (Exception e) {
            this.fLogger.warning("SkinsRestorer hook is failed, check https://skinsrestorer.net/docs/installation");
        }
    }

    @Async(delay=20L)
    public void hookLater() {
        this.hook();
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 SkinsRestorer unhooked");
    }

    public String getTextureUrl(FPlayer fPlayer) {
        SkinProperty skinProperty = this.getSkinProperty(fPlayer);
        if (skinProperty == null) {
            return null;
        }
        return PropertyUtils.getSkinTextureHash((SkinProperty)skinProperty);
    }

    public PlayerHeadObjectContents.ProfileProperty getProfileProperty(FPlayer fPlayer) {
        if (this.skinsRestorer == null) {
            return null;
        }
        SkinProperty skinProperty = this.getSkinProperty(fPlayer);
        if (skinProperty == null) {
            return null;
        }
        return this.convertToProfileProperty(skinProperty);
    }

    private SkinProperty getSkinProperty(FPlayer fPlayer) {
        if (this.skinsRestorer == null) {
            return null;
        }
        PlayerStorage storage = this.skinsRestorer.getPlayerStorage();
        try {
            Optional skin = storage.getSkinForPlayer(fPlayer.getUuid(), fPlayer.getName());
            return skin.orElse(null);
        }
        catch (DataRequestException e) {
            return null;
        }
    }

    private PlayerHeadObjectContents.ProfileProperty convertToProfileProperty(SkinProperty skinProperty) {
        return PlayerHeadObjectContents.property((String)"textures", (String)skinProperty.getValue(), (String)skinProperty.getSignature());
    }

    @Inject
    @Generated
    public SkinsRestorerIntegration(FlectonePulse flectonePulse, PlatformPlayerAdapter platformPlayerAdapter, Provider<SkinService> skinServiceProvider, FLogger fLogger) {
        this.flectonePulse = flectonePulse;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.skinServiceProvider = skinServiceProvider;
        this.fLogger = fLogger;
    }
}

