/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.telegram;

import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.flectone.pulse.library.apache.lang3.math.NumberUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.module.integration.telegram.listener.MessageListener;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.logging.FLogger;
import org.telegram.telegrambots.client.okhttp.OkHttpTelegramClient;
import org.telegram.telegrambots.longpolling.TelegramBotsLongPollingApplication;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.forum.EditForumTopic;
import org.telegram.telegrambots.meta.api.methods.groupadministration.SetChatTitle;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

@Singleton
public class TelegramIntegration
implements FIntegration {
    private final FileResolver fileResolver;
    private final SystemVariableResolver systemVariableResolver;
    private final FLogger fLogger;
    private final MessageListener messageListener;
    private final MessagePipeline messagePipeline;
    private final TaskScheduler taskScheduler;
    private TelegramBotsLongPollingApplication botsApplication;
    private OkHttpTelegramClient telegramClient;

    public Integration.Telegram config() {
        return this.fileResolver.getIntegration().getTelegram();
    }

    @Override
    public void hook() {
        String token = this.systemVariableResolver.substituteEnvVars(this.config().getToken());
        if (token.isEmpty()) {
            return;
        }
        try {
            this.telegramClient = new OkHttpTelegramClient(token);
            this.botsApplication = new TelegramBotsLongPollingApplication();
            this.botsApplication.registerBot(token, (LongPollingUpdateConsumer)this.messageListener);
            Integration.ChannelInfo channelInfo = this.config().getChannelInfo();
            if (channelInfo.isEnable() && channelInfo.getTicker().isEnable()) {
                long period = channelInfo.getTicker().getPeriod();
                this.taskScheduler.runAsyncTimer(this::updateChannelInfo, period, period);
                this.updateChannelInfo();
            }
            this.fLogger.info("\u2714 Telegram integration enabled");
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> telegramString) {
        if (this.botsApplication == null) {
            return;
        }
        List<String> channels = this.config().getMessageChannel().get(messageName);
        if (channels == null) {
            return;
        }
        if (channels.isEmpty()) {
            return;
        }
        Localization.Integration.Telegram localization = this.fileResolver.getLocalization().getIntegration().getTelegram();
        String message = localization.getMessageChannel().getOrDefault(messageName, "<final_message>");
        if (message.isEmpty()) {
            return;
        }
        message = (String)telegramString.apply(message);
        for (String chat : channels) {
            SendMessage.SendMessageBuilder sendMessageBuilder = SendMessage.builder().chatId(chat).text(message);
            if (chat.contains("_")) {
                sendMessageBuilder.messageThreadId(Integer.valueOf(Integer.parseInt(chat.split("_")[1])));
            }
            this.executeMethod((BotApiMethod<?>)sendMessageBuilder.build());
        }
    }

    @Override
    public void unhook() {
        if (this.botsApplication == null) {
            return;
        }
        try {
            this.botsApplication.close();
        }
        catch (Exception e) {
            this.fLogger.warning(e);
        }
        this.fLogger.info("\u2716 Telegram integration disabled");
    }

    public void updateChannelInfo() {
        if (this.botsApplication == null) {
            return;
        }
        if (!this.config().getChannelInfo().isEnable()) {
            return;
        }
        Localization.Integration.Telegram localization = this.fileResolver.getLocalization().getIntegration().getTelegram();
        for (Map.Entry<String, String> entry : localization.getInfoChannel().entrySet()) {
            String chatId = entry.getKey();
            if (chatId.contains("_")) {
                String[] ids = chatId.split("_");
                if (ids.length != 2 || !NumberUtils.isParsable((String)ids[0]) || !NumberUtils.isParsable((String)ids[1])) continue;
                this.executeMethod((BotApiMethod<?>)EditForumTopic.builder().chatId(ids[0]).messageThreadId(Integer.valueOf(Integer.parseInt(ids[1]))).name(this.getNewChatName(entry.getValue())).build());
                continue;
            }
            this.executeMethod((BotApiMethod<?>)SetChatTitle.builder().chatId(chatId).title(this.getNewChatName(entry.getValue())).build());
        }
    }

    private String getNewChatName(String value) {
        return PlainTextComponentSerializer.plainText().serialize(this.messagePipeline.builder(value).build());
    }

    public void executeMethod(BotApiMethod<?> method) {
        try {
            this.telegramClient.executeAsync(method);
        }
        catch (TelegramApiException e) {
            this.fLogger.warning(e);
        }
    }

    @Inject
    @Generated
    public TelegramIntegration(FileResolver fileResolver, SystemVariableResolver systemVariableResolver, FLogger fLogger, MessageListener messageListener, MessagePipeline messagePipeline, TaskScheduler taskScheduler) {
        this.fileResolver = fileResolver;
        this.systemVariableResolver = systemVariableResolver;
        this.fLogger = fLogger;
        this.messageListener = messageListener;
        this.messagePipeline = messagePipeline;
        this.taskScheduler = taskScheduler;
    }
}

