/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.telegram;

import java.util.function.UnaryOperator;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.telegram.TelegramIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class TelegramModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Override
    public void onEnable() {
        super.onEnable();
        this.reflectionResolver.hasClassOrElse("org.telegram.telegrambots.client.okhttp.OkHttpTelegramClient", this::loadLibraries);
        ((TelegramIntegration)this.injector.getInstance(TelegramIntegration.class)).hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ((TelegramIntegration)this.injector.getInstance(TelegramIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("org{}telegram").artifactId("telegrambots-longpolling").version("9.2.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("org{}telegram").artifactId("telegrambots-client").version("9.2.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}squareup{}okhttp3").artifactId("okhttp").version("5.0.0-alpha.14").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
    }

    @Override
    public Integration.Telegram config() {
        return this.fileResolver.getIntegration().getTelegram();
    }

    @Override
    public Permission.Integration.Telegram permission() {
        return this.fileResolver.getPermission().getIntegration().getTelegram();
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> telegramString) {
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        ((TelegramIntegration)this.injector.getInstance(TelegramIntegration.class)).sendMessage(sender, messageName, telegramString);
    }

    @Inject
    @Generated
    public TelegramModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.fileResolver = fileResolver;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }
}

