/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.telegram.listener;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.integration.telegram.TelegramIntegration;
import net.flectone.pulse.module.integration.telegram.listener.EventListener;
import net.flectone.pulse.module.integration.telegram.model.TelegramMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.DeleteMessage;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.api.objects.message.Message;

@Singleton
public class MessageListener
extends EventListener {
    private final FileResolver fileResolver;
    private final Provider<TelegramIntegration> telegramIntegration;

    @Override
    public void onEnable() {
    }

    @Override
    public Integration.Telegram config() {
        return this.fileResolver.getIntegration().getTelegram();
    }

    @Override
    public Permission.Integration.Telegram permission() {
        return this.fileResolver.getPermission().getIntegration().getTelegram();
    }

    @Override
    public Localization.Integration.Telegram localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getIntegration().getTelegram();
    }

    public void consume(Update update) {
        String text;
        if (!update.hasMessage()) {
            return;
        }
        Message message = update.getMessage();
        if (this.isNewChatNameMessage(message)) {
            String chatId = this.getChatId(message);
            if (((Localization.Integration.Telegram)this.localization()).getInfoChannel().containsKey(chatId)) {
                this.deleteMessage(chatId, message.getMessageId());
            }
        }
        if ((text = message.getText()) == null) {
            return;
        }
        User author = message.getFrom();
        if (author == null) {
            return;
        }
        String chat = message.getChat().getTitle();
        if (chat == null) {
            return;
        }
        String chatID = this.getChatId(message);
        if (text.equalsIgnoreCase("/id")) {
            this.sendInfoMessage(chatID, message);
            return;
        }
        List<String> chats = this.config().getMessageChannel().get(MessageType.FROM_TELEGRAM_TO_MINECRAFT.name());
        if (chats == null || !chats.contains(chatID)) {
            return;
        }
        this.sendMessage(author, chat, text);
    }

    @Async
    public void sendMessage(User user, String chat, String message) {
        String userName = StringUtils.defaultString((String)user.getUserName());
        String firstName = user.getFirstName();
        String lastName = StringUtils.defaultString((String)user.getLastName());
        this.sendMessage(((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)((TelegramMetadata.TelegramMetadataBuilder)TelegramMetadata.builder().sender(FPlayer.UNKNOWN)).format(localization -> StringUtils.replaceEach((String)localization.getForMinecraft(), (String[])new String[]{"<name>", "<user_name>", "<first_name>", "<last_name>", "<chat>"}, (String[])new String[]{userName, userName, firstName, lastName, StringUtils.defaultString((String)chat)}))).userName(userName)).firstName(firstName)).lastName(lastName)).chat(chat)).message(message)).range(Range.get(Range.Type.PROXY))).destination(this.config().getDestination())).sound(this.getModuleSound())).integration(string -> StringUtils.replaceEach((String)string, (String[])new String[]{"<name>", "<user_name>", "<first_name>", "<last_name>", "<chat>"}, (String[])new String[]{userName, userName, firstName, lastName, StringUtils.defaultString((String)chat)}))).build());
    }

    private boolean isNewChatNameMessage(Message message) {
        if (message.getNewChatTitle() == null && message.getForumTopicEdited() == null) {
            return false;
        }
        User user = message.getFrom();
        return user != null && user.getIsBot() != false;
    }

    private String getChatId(Message message) {
        return message.getChatId() + (String)(message.isTopicMessage() ? "_" + message.getMessageThreadId() : "");
    }

    private void deleteMessage(String chatId, Integer messageId) {
        ((TelegramIntegration)this.telegramIntegration.get()).executeMethod((BotApiMethod<?>)DeleteMessage.builder().chatId(chatId).messageId(messageId).build());
    }

    private void sendInfoMessage(String chatID, Message message) {
        SendMessage.SendMessageBuilder sendMessage = SendMessage.builder().chatId(chatID).text("Channel id: " + chatID);
        if (message.isTopicMessage()) {
            sendMessage = sendMessage.messageThreadId(message.getMessageThreadId());
        }
        ((TelegramIntegration)this.telegramIntegration.get()).executeMethod((BotApiMethod<?>)sendMessage.build());
    }

    @Inject
    @Generated
    public MessageListener(FileResolver fileResolver, Provider<TelegramIntegration> telegramIntegration) {
        this.fileResolver = fileResolver;
        this.telegramIntegration = telegramIntegration;
    }
}

