/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.triton;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.triton.TritonIntegration;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import org.jetbrains.annotations.Nullable;

@Singleton
public class TritonModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final TritonIntegration tritonIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(TritonIntegration.class);
        this.tritonIntegration.hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.tritonIntegration.unhook();
    }

    @Override
    public Integration.Triton config() {
        return this.fileResolver.getIntegration().getTriton();
    }

    @Override
    public Permission.Integration.Triton permission() {
        return this.fileResolver.getPermission().getIntegration().getTriton();
    }

    @Nullable
    public String getLocale(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return null;
        }
        return this.tritonIntegration.getLocale(fPlayer);
    }

    @Inject
    @Generated
    public TritonModule(FileResolver fileResolver, TritonIntegration tritonIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.tritonIntegration = tritonIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

