/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.twitch;

import java.util.function.UnaryOperator;
import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.twitch.TwitchIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class TwitchModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Override
    public void onEnable() {
        super.onEnable();
        this.reflectionResolver.hasClassOrElse("com.github.twitch4j.TwitchClient", this::loadLibraries);
        ((TwitchIntegration)this.injector.getInstance(TwitchIntegration.class)).hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ((TwitchIntegration)this.injector.getInstance(TwitchIntegration.class)).unhook();
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}philippheuer{}credentialmanager").artifactId("credentialmanager").version("0.3.1").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}philippheuer{}events4j").artifactId("events4j-core").version("0.12.2").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}philippheuer{}events4j").artifactId("events4j-handler-simple").version("0.12.2").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-chat").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-auth").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-common").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-client-websocket").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-util").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-eventsub-common").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-eventsub-websocket").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-extensions").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-graphql").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-helix").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-kraken").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-messaginginterface").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-pubsub").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}twitch4j").artifactId("twitch4j-util").version("1.25.0").repository("https://repo1.maven.org/maven2/").build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}neovisionaries").artifactId("nv-websocket-client").version("2.14").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}bucket4j").artifactId("bucket4j_jdk8-core").version("8.10.1").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("org{}slf4j").artifactId("slf4j-api").version("2.1.0-alpha1").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("io{}github{}openfeign").artifactId("feign-slf4j").version("13.6").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("io{}github{}openfeign").artifactId("feign-okhttp").version("13.6").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("io{}github{}openfeign").artifactId("feign-jackson").version("13.6").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("io{}github{}openfeign").artifactId("feign-hystrix").version("13.6").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}fasterxml{}jackson{}core").artifactId("jackson-core").version("2.15.0-rc3").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}fasterxml{}jackson{}core").artifactId("jackson-databind").version("2.15.0-rc3").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}fasterxml{}jackson{}core").artifactId("jackson-annotations").version("2.15.0-rc3").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}fasterxml{}jackson{}datatype").artifactId("jackson-datatype-jsr310").version("2.15.0-rc3").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}github{}tony19").artifactId("named-regexp").version("1.0.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("org{}jetbrains").artifactId("annotations").version("26.0.2").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}netflix{}hystrix").artifactId("hystrix-core").version("1.5.18").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("com{}squareup{}okhttp3").artifactId("okhttp").version("4.12.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("commons-configuration").artifactId("commons-configuration").version("1.10").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("commons-io").artifactId("commons-io").version("2.19.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("io{}github{}xanthic{}cache").artifactId("cache-provider-caffeine").version("0.6.1").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
        libraryResolver.loadLibrary(Library.builder().groupId("org{}apache{}commons").artifactId("commons-lang3").version("3.17.0").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
    }

    @Override
    public Integration.Twitch config() {
        return this.fileResolver.getIntegration().getTwitch();
    }

    @Override
    public Permission.Integration.Twitch permission() {
        return this.fileResolver.getPermission().getIntegration().getTwitch();
    }

    public void sendMessage(FEntity sender, String messageName, UnaryOperator<String> twitchString) {
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        ((TwitchIntegration)this.injector.getInstance(TwitchIntegration.class)).sendMessage(sender, messageName, twitchString);
    }

    @Inject
    @Generated
    public TwitchModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.fileResolver = fileResolver;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }
}

