/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.afk.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.model.event.message.MessagePrepareEvent;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.model.event.player.PlayerQuitEvent;
import net.flectone.pulse.module.message.afk.AfkModule;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;

@Singleton
public class AfkPulseListener
implements PulseListener {
    private final AfkModule afkModule;

    @Pulse(ignoreCancelled=true)
    public void onMessagePrepareEvent(MessagePrepareEvent event) {
        String messageType = event.getMessageType().name();
        if (event.getMessageType() != MessageType.CHAT && !messageType.startsWith("COMMAND_")) {
            return;
        }
        EventMetadata<?> eventMetadata = event.getEventMetadata();
        FEntity fEntity = eventMetadata.getSender();
        if (!(fEntity instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)fEntity;
        if (fPlayer.getSetting(SettingText.AFK_SUFFIX) == null) {
            return;
        }
        int commandIndex = messageType.indexOf(95);
        String action = (commandIndex == -1 ? messageType : messageType.substring(commandIndex + 1)).toLowerCase();
        this.afkModule.remove(action, fPlayer);
    }

    @Pulse
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.afkModule.remove("", fPlayer);
    }

    @Pulse
    public void onPlayerLoadEvent(PlayerLoadEvent event) {
        if (!event.isReload()) {
            return;
        }
        FPlayer fPlayer = event.getPlayer();
        this.afkModule.remove("", fPlayer);
    }

    @Pulse(priority=Event.Priority.LOW)
    public void onPlayerQuit(PlayerQuitEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.afkModule.remove("quit", fPlayer);
    }

    @Pulse(priority=Event.Priority.HIGH)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        this.afkModule.addTag(messageContext);
    }

    @Inject
    @Generated
    public AfkPulseListener(AfkModule afkModule) {
        this.afkModule = afkModule;
    }
}

