/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.auto;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class AutoModule
extends AbstractModuleListLocalization<Localization.Message.Auto> {
    private final FileResolver fileResolver;
    private final TaskScheduler taskScheduler;
    private final FPlayerService fPlayerService;

    @Override
    public void onEnable() {
        super.onEnable();
        this.config().getTypes().forEach((key, value) -> {
            Sound sound = this.createSound(value.getSound(), this.permission().getTypes().get(key));
            Ticker ticker = value.getTicker();
            if (ticker.isEnable()) {
                this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(fPlayer -> this.send((FPlayer)fPlayer, (String)key, (Message.Auto.Type)value, sound)), ticker.getPeriod());
            }
        });
    }

    @Override
    public MessageType messageType() {
        return MessageType.AUTO;
    }

    @Override
    public Message.Auto config() {
        return this.fileResolver.getMessage().getAuto();
    }

    @Override
    public Permission.Message.Auto permission() {
        return this.fileResolver.getPermission().getMessage().getAuto();
    }

    @Override
    public Localization.Message.Auto localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getAuto();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return Collections.emptyList();
    }

    public void send(FPlayer fPlayer, String name, Message.Auto.Type type, Sound sound) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        List<String> messages = this.localization(fPlayer).getTypes().get(name);
        if (messages == null) {
            return;
        }
        String format = this.getNextMessage(fPlayer, type.isRandom(), messages);
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).destination(type.getDestination())).sound(sound)).build());
    }

    @Inject
    @Generated
    public AutoModule(FileResolver fileResolver, TaskScheduler taskScheduler, FPlayerService fPlayerService) {
        this.fileResolver = fileResolver;
        this.taskScheduler = taskScheduler;
        this.fPlayerService = fPlayerService;
    }
}

