/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.brand;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleListLocalization;
import net.flectone.pulse.module.message.brand.listener.BrandPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class BrandModule
extends AbstractModuleListLocalization<Localization.Message.Brand> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final TaskScheduler taskScheduler;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        Ticker ticker = this.config().getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::send), ticker.getPeriod());
        }
        this.listenerRegistry.register(BrandPulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.BRAND;
    }

    @Override
    public Message.Brand config() {
        return this.fileResolver.getMessage().getBrand();
    }

    @Override
    public Permission.Message.Brand permission() {
        return this.fileResolver.getPermission().getMessage().getBrand();
    }

    @Override
    public Localization.Message.Brand localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getBrand();
    }

    @Override
    public List<String> getAvailableMessages(FPlayer fPlayer) {
        return this.localization(fPlayer).getValues();
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        String format = this.getNextMessage(fPlayer, this.config().isRandom());
        if (StringUtils.isEmpty((CharSequence)format)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(format)).destination(this.config().getDestination())).build());
    }

    @Inject
    @Generated
    public BrandModule(FileResolver fileResolver, FPlayerService fPlayerService, TaskScheduler taskScheduler, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.taskScheduler = taskScheduler;
        this.listenerRegistry = listenerRegistry;
    }
}

