/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.bubble.renderer;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.protocol.entity.data.EntityData;
import net.flectone.pulse.library.packetevents.protocol.entity.data.EntityDataTypes;
import net.flectone.pulse.library.packetevents.protocol.entity.type.EntityType;
import net.flectone.pulse.library.packetevents.protocol.entity.type.EntityTypes;
import net.flectone.pulse.library.packetevents.protocol.player.GameMode;
import net.flectone.pulse.library.packetevents.protocol.potion.PotionTypes;
import net.flectone.pulse.library.packetevents.protocol.world.Location;
import net.flectone.pulse.library.packetevents.util.Vector3f;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerDestroyEntities;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerSetPassengers;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerSpawnEntity;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.bubble.model.Bubble;
import net.flectone.pulse.module.message.bubble.model.BubbleEntity;
import net.flectone.pulse.module.message.bubble.model.ModernBubble;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.RandomUtil;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class BubbleRenderer {
    private final Map<String, Deque<BubbleEntity>> activeBubbleEntities = new ConcurrentHashMap<String, Deque<BubbleEntity>>();
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final PacketSender packetSender;
    private final PacketProvider packetProvider;
    private final MessagePipeline messagePipeline;
    private final IntegrationModule integrationModule;
    private final TaskScheduler taskScheduler;
    private final RandomUtil randomUtil;

    public void renderBubble(Bubble bubble) {
        FPlayer sender = bubble.getSender();
        if (!this.isCorrectPlayer(sender)) {
            return;
        }
        Message.Bubble config = this.fileResolver.getMessage().getBubble();
        double viewDistance = config.getDistance();
        CompletableFuture nearbyEntitiesFuture = new CompletableFuture();
        this.taskScheduler.runSyncRegion(this.platformPlayerAdapter.convertToPlatformPlayer(sender), () -> {
            Set<UUID> nearbyEntities = this.platformPlayerAdapter.findPlayersWhoCanSee(sender, viewDistance, viewDistance, viewDistance);
            nearbyEntitiesFuture.complete(nearbyEntities);
        });
        nearbyEntitiesFuture.thenAccept(nearbyEntities -> nearbyEntities.stream().map(this.fPlayerService::getFPlayer).filter(fViewer -> !bubble.getViewers().isEmpty() && bubble.getViewers().contains(fViewer)).filter(fViewer -> !fViewer.isUnknown()).filter(fViewer -> !fViewer.isIgnored(sender)).filter(fViewer -> this.integrationModule.canSeeVanished(sender, (FEntity)fViewer)).forEach(fViewer -> this.renderBubble((FPlayer)fViewer, bubble)));
    }

    public void renderBubble(FPlayer fViewer, Bubble bubble) {
        Component formattedMessage = this.createFormattedMessage(bubble, fViewer);
        FPlayer sender = bubble.getSender();
        String key = sender.getUuid().toString() + String.valueOf(fViewer.getUuid());
        Deque bubbleEntities = this.activeBubbleEntities.getOrDefault(key, new ConcurrentLinkedDeque());
        BubbleEntity bubbleEntity = this.createBubbleEntity(bubble, formattedMessage, fViewer);
        bubbleEntities.push(bubbleEntity);
        for (int i = 0; i < bubble.getElevation(); ++i) {
            bubbleEntities.push(this.createSpaceBubbleEntity(bubble, fViewer));
        }
        this.activeBubbleEntities.put(key, bubbleEntities);
        this.rideEntities(sender, fViewer);
    }

    public void removeBubble(Bubble bubble) {
        this.activeBubbleEntities.forEach((uuid, bubbleEntities) -> {
            if (bubbleEntities.isEmpty()) {
                return;
            }
            List<BubbleEntity> bubbleEntitiesToRemove = bubbleEntities.stream().filter(bubbleEntity -> bubbleEntity.getBubble().getId() == bubble.getId()).toList();
            if (bubbleEntitiesToRemove.isEmpty()) {
                return;
            }
            bubbleEntitiesToRemove.forEach(this::despawnBubbleEntity);
            bubbleEntities.removeAll(bubbleEntitiesToRemove);
            this.rideEntities(bubble.getSender(), J_U_List.getFirst(bubbleEntitiesToRemove).getViewer());
        });
    }

    private void rideEntities(FPlayer sender, FPlayer viewer) {
        Deque<BubbleEntity> bubbleEntities = this.activeBubbleEntities.get(sender.getUuid().toString() + String.valueOf(viewer.getUuid()));
        if (bubbleEntities == null) {
            return;
        }
        if (bubbleEntities.isEmpty()) {
            return;
        }
        if (!this.isCorrectPlayer(sender)) {
            return;
        }
        if (!this.integrationModule.canSeeVanished(sender, viewer)) {
            return;
        }
        boolean hasSeenVisible = false;
        boolean hasSpawnedSpace = false;
        int lastID = this.platformPlayerAdapter.getEntityId(sender.getUuid());
        for (BubbleEntity bubbleEntity : bubbleEntities) {
            if (bubbleEntity.isVisible()) {
                hasSpawnedSpace = false;
                hasSeenVisible = true;
            } else if (hasSeenVisible && hasSpawnedSpace) continue;
            this.spawnEntity(bubbleEntity);
            lastID = this.rideEntity(bubbleEntity, lastID, new int[]{bubbleEntity.getId()});
            if (bubbleEntity.isVisible() || !hasSeenVisible) continue;
            hasSpawnedSpace = true;
        }
    }

    private int rideEntity(BubbleEntity nextBubbleEntity, int entityId, int[] passengersIds) {
        this.packetSender.send(nextBubbleEntity.getViewer(), (PacketWrapper<?>)new WrapperPlayServerSetPassengers(entityId, passengersIds));
        return nextBubbleEntity.getId();
    }

    private Component createFormattedMessage(Bubble bubble, FPlayer viewer) {
        Localization.Message.Bubble localization = this.fileResolver.getLocalization(viewer).getMessage().getBubble();
        Component message = this.messagePipeline.builder(bubble.getSender(), viewer, bubble.getRawMessage()).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).build();
        return this.messagePipeline.builder(bubble.getSender(), viewer, localization.getFormat()).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).tagResolvers(TagResolver.resolver((String)"message", (argumentQueue, context) -> Tag.inserting((Component)message))).build();
    }

    private BubbleEntity createBubbleEntity(Bubble bubble, Component formattedMessage, FPlayer viewer) {
        int id = this.randomUtil.nextInt(Integer.MAX_VALUE);
        EntityType entityType = bubble instanceof ModernBubble ? EntityTypes.TEXT_DISPLAY : EntityTypes.AREA_EFFECT_CLOUD;
        return new BubbleEntity(id, entityType, bubble, viewer, formattedMessage);
    }

    private BubbleEntity createSpaceBubbleEntity(Bubble bubble, FPlayer viewer) {
        int spaceEntityId = this.randomUtil.nextInt(Integer.MAX_VALUE);
        EntityType spaceBubbleEntityType = bubble.isInteractionRiding() ? EntityTypes.INTERACTION : EntityTypes.AREA_EFFECT_CLOUD;
        return new BubbleEntity(spaceEntityId, spaceBubbleEntityType, bubble, viewer, (Component)Component.empty(), false);
    }

    private void despawnBubbleEntity(BubbleEntity bubbleEntity) {
        Bubble bubble;
        EntityType entityType = bubbleEntity.getEntityType();
        int despawnDelay = 0;
        if (entityType == EntityTypes.TEXT_DISPLAY && (bubble = bubbleEntity.getBubble()) instanceof ModernBubble) {
            ModernBubble bubble2 = (ModernBubble)bubble;
            this.interpolate(bubbleEntity, bubble2, new Vector3f());
            despawnDelay = bubble2.getAnimationTime();
        }
        this.taskScheduler.runAsyncLater(() -> this.packetSender.send(bubbleEntity.getViewer(), (PacketWrapper<?>)new WrapperPlayServerDestroyEntities(bubbleEntity.getId())), despawnDelay);
    }

    public void removeAllBubbles() {
        this.activeBubbleEntities.values().forEach(entities -> entities.forEach(this::despawnBubbleEntity));
        this.activeBubbleEntities.clear();
    }

    private void spawnEntity(BubbleEntity bubbleEntity) {
        if (bubbleEntity.isCreated()) {
            return;
        }
        Location location = this.platformPlayerAdapter.getLocation(bubbleEntity.getBubble().getSender());
        if (location == null) {
            return;
        }
        location.setPosition(location.getPosition().add(0.0, 1.8, 0.0));
        int id = bubbleEntity.getId();
        EntityType entityType = bubbleEntity.getEntityType();
        this.packetSender.send(bubbleEntity.getViewer(), (PacketWrapper<?>)new WrapperPlayServerSpawnEntity(id, UUID.randomUUID(), entityType, location, 0.0f, 0, null));
        List<EntityData<?>> metadataList = this.createEntityData(bubbleEntity);
        this.packetSender.send(bubbleEntity.getViewer(), (PacketWrapper<?>)new WrapperPlayServerEntityMetadata(id, metadataList));
        bubbleEntity.setCreated(true);
        bubbleEntity.getBubble().setCreated(true);
        this.taskScheduler.runAsyncLater(() -> {
            Bubble patt0$temp;
            if (entityType == EntityTypes.TEXT_DISPLAY && (patt0$temp = bubbleEntity.getBubble()) instanceof ModernBubble) {
                ModernBubble bubble = (ModernBubble)patt0$temp;
                this.interpolate(bubbleEntity, bubble, new Vector3f(bubble.getScale(), bubble.getScale(), bubble.getScale()));
            }
        }, 1L);
    }

    private void interpolate(BubbleEntity bubbleEntity, ModernBubble bubble, Vector3f scale) {
        ArrayList<EntityData> metadataList = new ArrayList<EntityData>();
        metadataList.add(new EntityData(8, EntityDataTypes.INT, (Object)-1));
        metadataList.add(new EntityData(9, EntityDataTypes.INT, (Object)bubble.getAnimationTime()));
        metadataList.add(new EntityData(12, EntityDataTypes.VECTOR3F, (Object)scale));
        this.packetSender.send(bubbleEntity.getViewer(), (PacketWrapper<?>)new WrapperPlayServerEntityMetadata(bubbleEntity.getId(), metadataList));
    }

    private List<EntityData<?>> createEntityData(BubbleEntity bubbleEntity) {
        Bubble bubble;
        ArrayList metadataList = new ArrayList();
        EntityType entityType = bubbleEntity.getEntityType();
        if (entityType == EntityTypes.TEXT_DISPLAY && (bubble = bubbleEntity.getBubble()) instanceof ModernBubble) {
            ModernBubble bubble2 = (ModernBubble)bubble;
            metadataList.add(new EntityData(12, EntityDataTypes.VECTOR3F, (Object)new Vector3f()));
            metadataList.add(new EntityData(15, EntityDataTypes.BYTE, (Object)((byte)bubble2.getBillboard().ordinal())));
            Component message = bubbleEntity.getMessage();
            metadataList.add(new EntityData(23, EntityDataTypes.ADV_COMPONENT, (Object)message));
            metadataList.add(new EntityData(24, EntityDataTypes.INT, (Object)100000));
            int backgroundColor = bubble2.getBackground();
            metadataList.add(new EntityData(25, EntityDataTypes.INT, (Object)backgroundColor));
            if (bubble2.isHasShadow()) {
                metadataList.add(new EntityData(27, EntityDataTypes.BYTE, (Object)1));
            }
            return metadataList;
        }
        if (entityType == EntityTypes.AREA_EFFECT_CLOUD) {
            Component message = bubbleEntity.getMessage();
            metadataList.add(new EntityData(2, EntityDataTypes.OPTIONAL_ADV_COMPONENT, Optional.of(message)));
            boolean visibleName = bubbleEntity.isVisible();
            metadataList.add(new EntityData(3, EntityDataTypes.BOOLEAN, (Object)visibleName));
            int radiusIndex = 8;
            if (this.packetProvider.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_13_2)) {
                radiusIndex = 6;
            } else if (this.packetProvider.getServerVersion().isOlderThanOrEquals(ServerVersion.V_1_16_5)) {
                radiusIndex = 7;
            }
            metadataList.add(new EntityData(radiusIndex, EntityDataTypes.FLOAT, (Object)Float.valueOf(0.0f)));
            return metadataList;
        }
        if (entityType == EntityTypes.INTERACTION) {
            metadataList.add(new EntityData(8, EntityDataTypes.FLOAT, (Object)Float.valueOf(1.0E-6f)));
            Bubble bubble3 = bubbleEntity.getBubble();
            float height = bubble3.getInteractionHeight();
            metadataList.add(new EntityData(9, EntityDataTypes.FLOAT, (Object)Float.valueOf(height)));
            return metadataList;
        }
        return metadataList;
    }

    public boolean isCorrectPlayer(FPlayer sender) {
        List<Integer> passengers = this.platformPlayerAdapter.getPassengers(sender);
        return this.platformPlayerAdapter.getGamemode(sender) != GameMode.SPECTATOR && !this.platformPlayerAdapter.hasPotionEffect(sender, PotionTypes.INVISIBILITY) && passengers.isEmpty();
    }

    @Inject
    @Generated
    public BubbleRenderer(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, PacketSender packetSender, PacketProvider packetProvider, MessagePipeline messagePipeline, IntegrationModule integrationModule, TaskScheduler taskScheduler, RandomUtil randomUtil) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.packetSender = packetSender;
        this.packetProvider = packetProvider;
        this.messagePipeline = messagePipeline;
        this.integrationModule = integrationModule;
        this.taskScheduler = taskScheduler;
        this.randomUtil = randomUtil;
    }
}

