/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.chat;

import net.flectone.pulse.config.Message;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.module.command.spy.SpyModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.bubble.BubbleModule;
import net.flectone.pulse.module.message.chat.ChatModule;
import net.flectone.pulse.module.message.chat.listener.ChatBukkitListener;
import net.flectone.pulse.module.message.chat.listener.ChatPaperListener;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.BukkitListenerRegistry;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.platform.sender.CooldownSender;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.MuteSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.event.EventPriority;

@Singleton
public class BukkitChatModule
extends ChatModule {
    private final FPlayerService fPlayerService;
    private final BukkitListenerRegistry listenerRegistry;
    private final ReflectionResolver reflectionResolver;
    private final FLogger fLogger;

    @Inject
    protected BukkitChatModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformServerAdapter platformServerAdapter, PermissionChecker permissionChecker, IntegrationModule integrationModule, Provider<BubbleModule> bubbleModuleProvider, Provider<SpyModule> spyModuleProvider, BukkitListenerRegistry listenerRegistry, ReflectionResolver reflectionResolver, MuteSender muteSender, DisableSender disableSender, CooldownSender cooldownSender, FLogger fLogger, ProxyRegistry proxyRegistry) {
        super(fileResolver, fPlayerService, platformServerAdapter, permissionChecker, integrationModule, bubbleModuleProvider, spyModuleProvider, listenerRegistry, muteSender, disableSender, cooldownSender, proxyRegistry);
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
        this.reflectionResolver = reflectionResolver;
        this.fLogger = fLogger;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        Message.Chat.Mode mode = this.config().getMode();
        if (mode == Message.Chat.Mode.PACKET) {
            return;
        }
        if (mode == Message.Chat.Mode.PAPER) {
            if (this.reflectionResolver.hasClass("io.papermc.paper.event.player.AsyncChatEvent")) {
                ChatPaperListener chatPaperListener = new ChatPaperListener(this.fPlayerService, this);
                this.listenerRegistry.register(chatPaperListener, EventPriority.valueOf((String)this.config().getPriority().name()));
                return;
            }
            this.fLogger.warning("It is not possible to use chat in PAPER mode on your server. BUKKIT mode is currently in use.");
        }
        this.listenerRegistry.register(ChatBukkitListener.class, this.config().getPriority());
    }
}

