/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.chat.listener;

import java.util.function.BiConsumer;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.chat.BukkitChatModule;
import net.flectone.pulse.service.FPlayerService;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@Singleton
public class ChatBukkitListener
implements Listener {
    private final FPlayerService fPlayerService;
    private final BukkitChatModule chatModule;

    @EventHandler
    public void asyncPlayerChatEvent(AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getRecipients().isEmpty()) {
            return;
        }
        if (!event.getFormat().equals("<%1$s> %2$s")) {
            return;
        }
        if (!this.chatModule.isEnable()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        if (this.chatModule.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Runnable cancelRunnable = () -> {
            event.setCancelled(true);
            event.getRecipients().clear();
        };
        BiConsumer<String, Boolean> successConsumer = (finalMessage, isCancel) -> {
            event.setMessage(finalMessage);
            event.setCancelled(isCancel.booleanValue());
            event.getRecipients().clear();
        };
        this.chatModule.handleChatEvent(fPlayer, event.getMessage(), cancelRunnable, successConsumer);
    }

    @Inject
    @Generated
    public ChatBukkitListener(FPlayerService fPlayerService, BukkitChatModule chatModule) {
        this.fPlayerService = fPlayerService;
        this.chatModule = chatModule;
    }
}

