/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.chat.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.event.PacketListener;
import net.flectone.pulse.library.packetevents.event.PacketReceiveEvent;
import net.flectone.pulse.library.packetevents.protocol.packettype.PacketType;
import net.flectone.pulse.library.packetevents.wrapper.play.client.WrapperPlayClientChatMessage;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.chat.ChatModule;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class ChatPacketListener
implements PacketListener {
    private final FPlayerService fPlayerService;
    private final ChatModule chatModule;

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() != PacketType.Play.Client.CHAT_MESSAGE) {
            return;
        }
        if (!this.chatModule.isEnable()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getUser().getUUID());
        if (this.chatModule.isModuleDisabledFor(fPlayer)) {
            return;
        }
        WrapperPlayClientChatMessage wrapper = new WrapperPlayClientChatMessage(event);
        String message = wrapper.getMessage();
        event.setCancelled(true);
        this.asyncSend(fPlayer, message);
    }

    @Async
    public void asyncSend(FPlayer fPlayer, String message) {
        this.chatModule.handleChatEvent(fPlayer, message, () -> {}, (string, value) -> {});
    }

    @Inject
    @Generated
    public ChatPacketListener(FPlayerService fPlayerService, ChatModule chatModule) {
        this.fPlayerService = fPlayerService;
        this.chatModule = chatModule;
    }
}

