/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format;

import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.format.StyleBuilderApplicable;
import net.flectone.pulse.library.adventure.text.format.TextColor;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.adventure.text.minimessage.tag.standard.StandardTags;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.fcolor.FColorModule;
import net.flectone.pulse.module.message.format.fixation.FixationModule;
import net.flectone.pulse.module.message.format.listener.FormatPulseListener;
import net.flectone.pulse.module.message.format.listener.LegacyColorPulseListener;
import net.flectone.pulse.module.message.format.mention.MentionModule;
import net.flectone.pulse.module.message.format.moderation.ModerationModule;
import net.flectone.pulse.module.message.format.names.NamesModule;
import net.flectone.pulse.module.message.format.object.ObjectModule;
import net.flectone.pulse.module.message.format.questionanswer.QuestionAnswerModule;
import net.flectone.pulse.module.message.format.replacement.ReplacementModule;
import net.flectone.pulse.module.message.format.scoreboard.ScoreboardModule;
import net.flectone.pulse.module.message.format.translate.TranslateModule;
import net.flectone.pulse.module.message.format.world.WorldModule;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.AdventureTag;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class FormatModule
extends AbstractModuleLocalization<Localization.Message.Format> {
    private final Map<AdventureTag, TagResolver> tagResolverMap = new EnumMap<AdventureTag, TagResolver>(AdventureTag.class);
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final PermissionChecker permissionChecker;
    private final IntegrationModule integrationModule;

    @Override
    public void configureChildren() {
        super.configureChildren();
        this.addChildren(FColorModule.class);
        this.addChildren(FixationModule.class);
        this.addChildren(MentionModule.class);
        this.addChildren(ModerationModule.class);
        this.addChildren(NamesModule.class);
        this.addChildren(ObjectModule.class);
        this.addChildren(QuestionAnswerModule.class);
        this.addChildren(ReplacementModule.class);
        this.addChildren(ScoreboardModule.class);
        this.addChildren(TranslateModule.class);
        this.addChildren(WorldModule.class);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerPermission(this.permission().getLegacyColors());
        this.config().getAdventureTags().forEach(adventureTag -> this.registerPermission(this.permission().getAdventureTags().get(adventureTag)));
        this.putAdventureTag(AdventureTag.HOVER, StandardTags.hoverEvent());
        this.putAdventureTag(AdventureTag.CLICK, StandardTags.clickEvent());
        this.putAdventureTag(AdventureTag.COLOR, StandardTags.color());
        this.putAdventureTag(AdventureTag.KEYBIND, StandardTags.keybind());
        this.putAdventureTag(AdventureTag.TRANSLATABLE, StandardTags.translatable());
        this.putAdventureTag(AdventureTag.TRANSLATABLE_FALLBACK, StandardTags.translatableFallback());
        this.putAdventureTag(AdventureTag.INSERTION, StandardTags.insertion());
        this.putAdventureTag(AdventureTag.FONT, StandardTags.font());
        this.putAdventureTag(AdventureTag.DECORATION, StandardTags.decorations());
        this.putAdventureTag(AdventureTag.GRADIENT, StandardTags.gradient());
        this.putAdventureTag(AdventureTag.RAINBOW, StandardTags.rainbow());
        this.putAdventureTag(AdventureTag.RESET, StandardTags.reset());
        this.putAdventureTag(AdventureTag.NEWLINE, StandardTags.newline());
        this.putAdventureTag(AdventureTag.TRANSITION, StandardTags.transition());
        this.putAdventureTag(AdventureTag.SELECTOR, StandardTags.selector());
        this.putAdventureTag(AdventureTag.SCORE, StandardTags.score());
        this.putAdventureTag(AdventureTag.NBT, StandardTags.nbt());
        this.putAdventureTag(AdventureTag.PRIDE, StandardTags.pride());
        this.putAdventureTag(AdventureTag.SHADOW_COLOR, StandardTags.shadowColor());
        this.listenerRegistry.register(FormatPulseListener.class);
        if (this.config().isConvertLegacyColor()) {
            this.listenerRegistry.register(LegacyColorPulseListener.class);
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.tagResolverMap.clear();
    }

    @Override
    public MessageType messageType() {
        return MessageType.FORMAT;
    }

    @Override
    public Message.Format config() {
        return this.fileResolver.getMessage().getFormat();
    }

    @Override
    public Permission.Message.Format permission() {
        return this.fileResolver.getPermission().getMessage().getFormat();
    }

    @Override
    public Localization.Message.Format localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat();
    }

    public void addTags(MessageContext messageContext) {
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        boolean isUserMessage = messageContext.isFlag(MessageFlag.USER_MESSAGE);
        this.tagResolverMap.entrySet().stream().filter(entry -> this.isCorrectTag((AdventureTag)((Object)((Object)entry.getKey())), sender, isUserMessage)).forEach(entry -> {
            if (entry.getKey() == AdventureTag.GRADIENT && this.integrationModule.isBedrockPlayer(messageContext.getReceiver())) {
                messageContext.addReplacementTag(this.bedrockGradientTag());
                return;
            }
            messageContext.addReplacementTag((TagResolver)entry.getValue());
        });
    }

    public boolean isCorrectTag(AdventureTag adventureTag, FEntity sender, boolean needPermission) {
        if (!this.config().getAdventureTags().contains((Object)adventureTag)) {
            return false;
        }
        if (!this.tagResolverMap.containsKey((Object)adventureTag)) {
            return false;
        }
        return !needPermission || this.permissionChecker.check(sender, this.permission().getAdventureTags().get((Object)adventureTag));
    }

    private TagResolver bedrockGradientTag() {
        return TagResolver.resolver((String)"gradient", (argumentQueue, context) -> {
            Tag.Argument argument = argumentQueue.peek();
            if (argument == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            TextColor textColor = TextColor.fromHexString((String)argument.value());
            if (textColor == null) {
                return Tag.selfClosingInserting((Component)Component.empty());
            }
            return Tag.styling((StyleBuilderApplicable[])new StyleBuilderApplicable[]{textColor});
        });
    }

    private void putAdventureTag(AdventureTag adventureTag, TagResolver tagResolver) {
        if (this.config().getAdventureTags().contains((Object)adventureTag)) {
            this.tagResolverMap.put(adventureTag, tagResolver);
        }
    }

    @Inject
    @Generated
    public FormatModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, PermissionChecker permissionChecker, IntegrationModule integrationModule) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.permissionChecker = permissionChecker;
        this.integrationModule = integrationModule;
    }
}

