/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.message.format.convertor.LegacyColorConvertor;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class LegacyColorPulseListener
implements PulseListener {
    private final LegacyColorConvertor legacyColorConvertor;

    @Pulse(priority=Event.Priority.HIGHEST)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        if (!messageContext.isFlag(MessageFlag.LEGACY_COLORS)) {
            return;
        }
        this.legacyColorConvertor.convert(messageContext);
    }

    @Inject
    @Generated
    public LegacyColorPulseListener(LegacyColorConvertor legacyColorConvertor) {
        this.legacyColorConvertor = legacyColorConvertor;
    }
}

