/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.delete;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.format.moderation.delete.listener.DeletePulseListener;
import net.flectone.pulse.module.message.format.moderation.delete.model.HistoryMessage;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.MessageSender;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class DeleteModule
extends AbstractModuleLocalization<Localization.Message.Format.Moderation.Delete> {
    private final Map<UUID, List<HistoryMessage>> playersHistory = new ConcurrentHashMap<UUID, List<HistoryMessage>>();
    private final List<Component> cachedComponents = new CopyOnWriteArrayList<Component>();
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final MessagePipeline messagePipeline;
    private final FPlayerService fPlayerService;
    private final MessageSender messageSender;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(DeletePulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.playersHistory.clear();
        this.cachedComponents.clear();
    }

    @Override
    public MessageType messageType() {
        return MessageType.DELETE;
    }

    @Override
    public Message.Format.Moderation.Delete config() {
        return this.fileResolver.getMessage().getFormat().getModeration().getDelete();
    }

    @Override
    public Permission.Message.Format.Moderation.Delete permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getModeration().getDelete();
    }

    @Override
    public Localization.Message.Format.Moderation.Delete localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getFormat().getModeration().getDelete();
    }

    public void clearHistory(FPlayer fPlayer) {
        this.playersHistory.remove(fPlayer.getUuid());
    }

    public void addTag(MessageContext messageContext) {
        if (messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        FPlayer receiver = messageContext.getReceiver();
        if (this.isModuleDisabledFor(receiver)) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (contextMessage == null || !contextMessage.contains("<delete>")) {
            return;
        }
        UUID messageUUID = messageContext.getMessageUUID();
        messageContext.addReplacementTag(MessagePipeline.ReplacementTag.DELETE, (argumentQueue, context) -> {
            String placeholder = Strings.CS.replace(this.localization(receiver).getPlaceholder(), "<uuid>", messageUUID.toString());
            Component componentPlaceholder = this.messagePipeline.builder(sender, receiver, placeholder).flag(MessageFlag.MENTION, false).flag(MessageFlag.INTERACTIVE_CHAT, false).flag(MessageFlag.QUESTION, false).flag(MessageFlag.DELETE, false).build();
            return Tag.selfClosingInserting((Component)componentPlaceholder);
        });
    }

    public void save(FPlayer receiver, UUID messageUUID, Component component, boolean needToCache) {
        if (receiver.isUnknown()) {
            return;
        }
        if (!receiver.isOnline()) {
            return;
        }
        UUID playerUUID = receiver.getUuid();
        HistoryMessage historyMessage = new HistoryMessage(messageUUID, component);
        List history = this.playersHistory.computeIfAbsent(playerUUID, k -> new ArrayList());
        if (history.size() >= this.config().getHistoryLength()) {
            J_U_List.removeFirst(history);
        }
        history.add(historyMessage);
        if (needToCache && !this.isCached(component)) {
            this.cachedComponents.add(component);
        }
    }

    public boolean isCached(Component component) {
        return this.cachedComponents.contains(component);
    }

    public void removeCache(Component component) {
        this.cachedComponents.remove(component);
    }

    public boolean remove(FEntity sender, UUID messageUUID) {
        if (this.isModuleDisabledFor(sender)) {
            return false;
        }
        if (messageUUID == null) {
            return false;
        }
        List<Map.Entry> entryToDelete = this.playersHistory.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(historyMessage -> historyMessage.uuid().equals(messageUUID))).toList();
        if (entryToDelete.isEmpty()) {
            return false;
        }
        entryToDelete.forEach(entry -> {
            UUID receiver = (UUID)entry.getKey();
            List history = (List)entry.getValue();
            FPlayer fReceiver = this.fPlayerService.getFPlayer(receiver);
            String format = this.localization(fReceiver).getFormat();
            if (format.isBlank()) {
                history.removeIf(historyMessage -> historyMessage.uuid().equals(messageUUID));
            } else {
                for (int i = 0; i < history.size(); ++i) {
                    HistoryMessage historyMessage2 = (HistoryMessage)history.get(i);
                    if (!messageUUID.equals(historyMessage2.uuid())) continue;
                    Component removedComponent = this.messagePipeline.builder(sender, fReceiver, format).build();
                    history.set(i, new HistoryMessage(messageUUID, removedComponent));
                }
            }
            this.sendUpdate(receiver);
        });
        return true;
    }

    public void sendUpdate(UUID receiver) {
        List<HistoryMessage> history = this.playersHistory.get(receiver);
        if (history == null) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(receiver);
        for (int i = 0; i < this.config().getHistoryLength(); ++i) {
            if (i < history.size()) continue;
            this.messageSender.sendMessage(fPlayer, (Component)Component.newline(), true);
        }
        history.forEach(historyMessage -> this.messageSender.sendMessage(fPlayer, historyMessage.component(), true));
    }

    @Inject
    @Generated
    public DeleteModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, MessagePipeline messagePipeline, FPlayerService fPlayerService, MessageSender messageSender) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.messagePipeline = messagePipeline;
        this.fPlayerService = fPlayerService;
        this.messageSender = messageSender;
    }
}

