/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.moderation.flood;

import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.format.moderation.flood.listener.FloodPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageFlag;

@Singleton
public class FloodModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final PermissionChecker permissionChecker;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(FloodPulseListener.class);
    }

    @Override
    public Message.Format.Moderation.Flood config() {
        return this.fileResolver.getMessage().getFormat().getModeration().getFlood();
    }

    @Override
    public Permission.Message.Format.Moderation.Flood permission() {
        return this.fileResolver.getPermission().getMessage().getFormat().getModeration().getFlood();
    }

    public void format(MessageContext messageContext) {
        if (!messageContext.isFlag(MessageFlag.USER_MESSAGE)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        if (this.isModuleDisabledFor(sender)) {
            return;
        }
        if (this.permissionChecker.check(sender, this.permission().getBypass())) {
            return;
        }
        String contextMessage = messageContext.getMessage();
        if (StringUtils.isEmpty((CharSequence)contextMessage)) {
            return;
        }
        contextMessage = this.replaceRepeatedSymbols(contextMessage);
        contextMessage = this.replaceRepeatedWords(contextMessage);
        messageContext.setMessage(contextMessage);
    }

    private String replaceRepeatedSymbols(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char prevChar = string.charAt(0);
        int count = 1;
        for (int i = 1; i < string.length(); ++i) {
            char currentChar = string.charAt(i);
            if (currentChar == prevChar) {
                ++count;
                continue;
            }
            this.appendSymbol(stringBuilder, prevChar, count);
            prevChar = currentChar;
            count = 1;
        }
        this.appendSymbol(stringBuilder, prevChar, count);
        return stringBuilder.toString();
    }

    private void appendSymbol(StringBuilder stringBuilder, char symbol, int count) {
        int counts = count > this.config().getMaxRepeatedSymbols() ? (this.config().isTrimToSingle() ? 1 : this.config().getMaxRepeatedSymbols()) : count;
        stringBuilder.append(String.valueOf(symbol).repeat(counts));
    }

    private String replaceRepeatedWords(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        String[] words = text.split(" ");
        if (words.length == 0) {
            return text;
        }
        String prevWord = words[0];
        int count = 1;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < words.length; ++i) {
            String currentWord = words[i];
            if (currentWord.equalsIgnoreCase(prevWord)) {
                ++count;
                continue;
            }
            this.appendWord(stringBuilder, prevWord, count);
            prevWord = currentWord;
            count = 1;
        }
        this.appendWord(stringBuilder, prevWord, count);
        return stringBuilder.toString().trim();
    }

    private void appendWord(StringBuilder stringBuilder, String word, int count) {
        int counts;
        int n = count > this.config().getMaxRepeatedWords() ? (this.config().isTrimToSingle() ? 1 : this.config().getMaxRepeatedWords()) : (counts = count);
        while (counts > 0) {
            --counts;
            stringBuilder.append(word).append(" ");
        }
    }

    @Inject
    @Generated
    public FloodModule(FileResolver fileResolver, PermissionChecker permissionChecker, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.permissionChecker = permissionChecker;
        this.listenerRegistry = listenerRegistry;
    }
}

