/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.format.world.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.model.event.player.PlayerJoinEvent;
import net.flectone.pulse.model.event.player.PlayerLoadEvent;
import net.flectone.pulse.module.message.format.world.WorldModule;
import net.flectone.pulse.processing.context.MessageContext;

@Singleton
public class WorldPulseListener
implements PulseListener {
    private final WorldModule worldModule;

    @Pulse
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        FPlayer fPlayer = event.getPlayer();
        this.worldModule.update(fPlayer);
    }

    @Pulse
    public void onPlayerLoadEvent(PlayerLoadEvent event) {
        if (!event.isReload()) {
            return;
        }
        FPlayer fPlayer = event.getPlayer();
        this.worldModule.update(fPlayer);
    }

    @Pulse(priority=Event.Priority.HIGH)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        this.worldModule.addTag(messageContext);
    }

    @Inject
    @Generated
    public WorldPulseListener(WorldModule worldModule) {
        this.worldModule = worldModule;
    }
}

