/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.greeting;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.FImage;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.greeting.listener.GreetingPulseListener;
import net.flectone.pulse.module.message.greeting.model.GreetingMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class GreetingModule
extends AbstractModuleLocalization<Localization.Message.Greeting> {
    private final FileResolver fileResolver;
    private final SkinService skinService;
    private final FLogger fLogger;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.createSound(this.config().getSound(), this.permission().getSound());
        this.listenerRegistry.register(GreetingPulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.GREETING;
    }

    @Override
    public Message.Greeting config() {
        return this.fileResolver.getMessage().getGreeting();
    }

    @Override
    public Permission.Message.Greeting permission() {
        return this.fileResolver.getPermission().getMessage().getGreeting();
    }

    @Override
    public Localization.Message.Greeting localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getGreeting();
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        FImage fImage = new FImage(this.skinService.getAvatarUrl(fPlayer));
        try {
            List<String> pixels = fImage.convertImageUrl();
            this.sendMessage(((GreetingMetadata.GreetingMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)((EventMetadata.EventMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)((GreetingMetadata.GreetingMetadataBuilder)GreetingMetadata.builder().sender(fPlayer)).format(s -> {
                String greetingMessage = String.join((CharSequence)"<br>", this.localization(fPlayer).getFormat());
                for (String pixel : pixels) {
                    greetingMessage = Strings.CS.replaceOnce(greetingMessage, "[#][#][#][#][#][#][#][#]", pixel);
                }
                return greetingMessage;
            })).pixels(pixels)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
        }
        catch (IOException | URISyntaxException e) {
            this.fLogger.warning(e);
        }
    }

    @Inject
    @Generated
    public GreetingModule(FileResolver fileResolver, SkinService skinService, FLogger fLogger, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.skinService = skinService;
        this.fLogger = fLogger;
        this.listenerRegistry = listenerRegistry;
    }
}

