/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.quit;

import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.quit.listener.QuitPulseListener;
import net.flectone.pulse.module.message.quit.model.QuitMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class QuitModule
extends AbstractModuleLocalization<Localization.Message.Quit> {
    private final FileResolver fileResolver;
    private final IntegrationModule integrationModule;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.createSound(this.config().getSound(), this.permission().getSound());
        this.listenerRegistry.register(QuitPulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.QUIT;
    }

    @Override
    public Message.Quit config() {
        return this.fileResolver.getMessage().getQuit();
    }

    @Override
    public Permission.Message.Quit permission() {
        return this.fileResolver.getPermission().getMessage().getQuit();
    }

    @Override
    public Localization.Message.Quit localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getQuit();
    }

    @Async
    public void send(FPlayer fPlayer, boolean ignoreVanish) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.sendMessage(((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((EventMetadata.EventMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)QuitMetadata.builder().sender(fPlayer)).format(Localization.Message.Quit::getFormat)).ignoreVanish(ignoreVanish)).destination(this.config().getDestination())).range(this.config().getRange())).sound(this.getModuleSound())).filter(fReceiver -> ignoreVanish || this.integrationModule.canSeeVanished(fPlayer, (FEntity)fReceiver))).integration()).proxy(dataOutputStream -> dataOutputStream.writeBoolean(ignoreVanish))).build());
    }

    @Inject
    @Generated
    public QuitModule(FileResolver fileResolver, IntegrationModule integrationModule, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.integrationModule = integrationModule;
        this.listenerRegistry = listenerRegistry;
    }
}

