/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.rightclick;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.protocol.potion.PotionTypes;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.rightclick.listener.RightclickPacketListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class RightclickModule
extends AbstractModuleLocalization<Localization.Message.Rightclick> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.createSound(this.config().getSound(), this.permission().getSound());
        this.createCooldown(this.config().getCooldown(), this.permission().getCooldownBypass());
        this.listenerRegistry.register(RightclickPacketListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.RIGHT_CLICK;
    }

    @Override
    public Message.Rightclick config() {
        return this.fileResolver.getMessage().getRightclick();
    }

    @Override
    public Permission.Message.Rightclick permission() {
        return this.fileResolver.getPermission().getMessage().getRightclick();
    }

    @Override
    public Localization.Message.Rightclick localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getRightclick();
    }

    @Async
    public void send(UUID uuid, int targetId) {
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        UUID targetUUID = this.platformPlayerAdapter.getPlayerByEntityId(targetId);
        if (targetUUID == null) {
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(targetUUID);
        if (fTarget.isUnknown()) {
            return;
        }
        if (this.config().isShouldCheckSneaking() && !this.platformPlayerAdapter.isSneaking(fPlayer)) {
            return;
        }
        if (this.config().isHideNameWhenInvisible() && this.platformPlayerAdapter.hasPotionEffect(fTarget, PotionTypes.INVISIBILITY)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fTarget)).filterPlayer(fPlayer)).format(Localization.Message.Rightclick::getFormat)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Inject
    @Generated
    public RightclickModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.listenerRegistry = listenerRegistry;
    }
}

