/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.sign.listener;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.sign.BukkitSignModule;
import net.flectone.pulse.service.FPlayerService;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

@Singleton
public class SignListener
implements Listener {
    private final FPlayerService fPlayerService;
    private final BukkitSignModule signModule;

    @EventHandler
    public void signChangeEvent(SignChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        for (int x = 0; x < event.getLines().length; ++x) {
            String string = event.getLine(x);
            if (string == null || string.isEmpty() || (string = this.signModule.format(fPlayer, string)) == null) continue;
            event.setLine(x, string);
        }
    }

    @Inject
    @Generated
    public SignListener(FPlayerService fPlayerService, BukkitSignModule signModule) {
        this.fPlayerService = fPlayerService;
        this.signModule = signModule;
    }
}

