/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.status;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.InetAddress;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.event.PacketSendEvent;
import net.flectone.pulse.library.packetevents.wrapper.status.server.WrapperStatusServerResponse;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.message.StatusResponseEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.message.status.icon.IconModule;
import net.flectone.pulse.module.message.status.listener.StatusPacketListener;
import net.flectone.pulse.module.message.status.motd.MOTDModule;
import net.flectone.pulse.module.message.status.players.PlayersModule;
import net.flectone.pulse.module.message.status.version.VersionModule;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class StatusModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final MOTDModule MOTDModule;
    private final IconModule iconModule;
    private final PlayersModule playersModule;
    private final VersionModule versionModule;
    private final MessagePipeline messagePipeline;
    private final PlatformServerAdapter platformServerAdapter;
    private final FPlayerService fPlayerService;
    private final ListenerRegistry listenerRegistry;
    private final PacketProvider packetProvider;
    private final EventDispatcher eventDispatcher;

    @Override
    public void configureChildren() {
        super.configureChildren();
        this.addChildren(MOTDModule.class);
        this.addChildren(IconModule.class);
        this.addChildren(PlayersModule.class);
        this.addChildren(VersionModule.class);
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.listenerRegistry.register(StatusPacketListener.class);
    }

    @Override
    public Message.Status config() {
        return this.fileResolver.getMessage().getStatus();
    }

    @Override
    public Permission.Message.Status permission() {
        return this.fileResolver.getPermission().getMessage().getStatus();
    }

    public void update(PacketSendEvent event) {
        InetAddress inetAddress = event.getUser().getAddress().getAddress();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(inetAddress);
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        this.fPlayerService.loadColors(fPlayer);
        JsonObject responseJson = new JsonObject();
        responseJson.add("version", this.getVersionJson(fPlayer));
        responseJson.add("players", this.getPlayersJson(fPlayer));
        responseJson.add("description", this.getDescriptionJson(fPlayer));
        String favicon = this.getFavicon(fPlayer);
        if (favicon != null) {
            responseJson.addProperty("favicon", favicon);
        }
        responseJson.addProperty("enforcesSecureChat", Boolean.valueOf(false));
        StatusResponseEvent responseEvent = new StatusResponseEvent(responseJson);
        this.eventDispatcher.dispatch(responseEvent);
        if (responseEvent.isCancelled()) {
            return;
        }
        event.markForReEncode(true);
        WrapperStatusServerResponse wrapperStatusServerResponse = new WrapperStatusServerResponse(event);
        wrapperStatusServerResponse.setComponent(responseJson);
    }

    private JsonElement getVersionJson(FPlayer fPlayer) {
        String version = this.versionModule.get(fPlayer);
        if (version == null) {
            version = this.packetProvider.getServerVersion().getReleaseName();
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", version);
        int protocol = this.packetProvider.getServerVersion().getProtocolVersion();
        if (this.versionModule.isEnable() && this.versionModule.config().getProtocol() != -1) {
            protocol = this.versionModule.config().getProtocol();
        }
        jsonObject.addProperty("protocol", (Number)protocol);
        return jsonObject;
    }

    private JsonElement getDescriptionJson(FPlayer fPlayer) {
        JsonElement jsonElement = this.MOTDModule.next(fPlayer);
        jsonElement = jsonElement == null ? this.platformServerAdapter.getMOTD() : jsonElement;
        return jsonElement;
    }

    private String getFavicon(FPlayer fPlayer) {
        String icon = this.iconModule.next(fPlayer);
        return icon == null ? null : "data:image/png;base64," + icon;
    }

    private JsonElement getPlayersJson(FPlayer fPlayer) {
        JsonObject playersJson = new JsonObject();
        int max = this.playersModule.isEnable() ? this.playersModule.config().getMax() : this.platformServerAdapter.getMaxPlayers();
        playersJson.addProperty("max", (Number)max);
        int online = this.playersModule.isEnable() ? (this.playersModule.config().getOnline() == -69 ? this.platformServerAdapter.getOnlinePlayerCount() : this.playersModule.config().getOnline()) : this.platformServerAdapter.getOnlinePlayerCount();
        playersJson.addProperty("online", (Number)online);
        playersJson.add("sample", this.getSampleJson(fPlayer));
        return playersJson;
    }

    private JsonElement getSampleJson(FPlayer fPlayer) {
        JsonArray jsonArray = new JsonArray();
        List<Localization.Message.Status.Players.Sample> samples = this.playersModule.getSamples(fPlayer);
        samples = samples == null ? List.of(new Localization.Message.Status.Players.Sample()) : samples;
        List<FPlayer> onlineFPlayers = this.fPlayerService.getVisibleFPlayersFor(fPlayer);
        samples.forEach(sample -> {
            if ("<players>".equalsIgnoreCase(sample.getName())) {
                onlineFPlayers.forEach(player -> {
                    JsonObject playerObject = new JsonObject();
                    playerObject.addProperty("name", player.getName());
                    playerObject.addProperty("id", player.getUuid().toString());
                    jsonArray.add((JsonElement)playerObject);
                });
                return;
            }
            JsonObject playerObject = new JsonObject();
            playerObject.addProperty("name", this.messagePipeline.builder(fPlayer, sample.getName()).legacySerializerBuild());
            playerObject.addProperty("id", sample.getId() == null ? onlineFPlayers.stream().findAny().orElse(FPlayer.UNKNOWN).getUuid().toString() : sample.getId());
            jsonArray.add((JsonElement)playerObject);
        });
        return jsonArray;
    }

    @Inject
    @Generated
    public StatusModule(FileResolver fileResolver, MOTDModule MOTDModule2, IconModule iconModule, PlayersModule playersModule, VersionModule versionModule, MessagePipeline messagePipeline, PlatformServerAdapter platformServerAdapter, FPlayerService fPlayerService, ListenerRegistry listenerRegistry, PacketProvider packetProvider, EventDispatcher eventDispatcher) {
        this.fileResolver = fileResolver;
        this.MOTDModule = MOTDModule2;
        this.iconModule = iconModule;
        this.playersModule = playersModule;
        this.versionModule = versionModule;
        this.messagePipeline = messagePipeline;
        this.platformServerAdapter = platformServerAdapter;
        this.fPlayerService = fPlayerService;
        this.listenerRegistry = listenerRegistry;
        this.packetProvider = packetProvider;
        this.eventDispatcher = eventDispatcher;
    }
}

