/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.tab.playerlist;

import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.object.PlayerHeadObjectContents;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.protocol.player.GameMode;
import net.flectone.pulse.library.packetevents.protocol.player.TextureProperty;
import net.flectone.pulse.library.packetevents.protocol.player.User;
import net.flectone.pulse.library.packetevents.protocol.player.UserProfile;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoRemove;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.scoreboard.ScoreboardModule;
import net.flectone.pulse.module.message.tab.playerlist.listener.PlayerlistnamePulseListener;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.SkinService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import org.jetbrains.annotations.Nullable;

@Singleton
public class PlayerlistnameModule
extends AbstractModuleLocalization<Localization.Message.Tab.Playerlistname> {
    private static final EnumSet<WrapperPlayServerPlayerInfoUpdate.Action> ADD_ACTIONS = EnumSet.of(WrapperPlayServerPlayerInfoUpdate.Action.ADD_PLAYER, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LISTED, WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME);
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final MessagePipeline messagePipeline;
    private final PacketSender packetSender;
    private final PacketProvider packetProvider;
    private final TaskScheduler taskScheduler;
    private final ListenerRegistry listenerRegistry;
    private final SkinService skinService;
    private final ProxyRegistry proxyRegistry;
    private final ScoreboardModule scoreboardModule;
    private final IntegrationModule integrationModule;

    @Override
    public void onEnable() {
        super.onEnable();
        this.fPlayerService.getPlatformFPlayers().forEach(this::send);
        Ticker ticker = this.config().getTicker();
        if (ticker.isEnable()) {
            this.taskScheduler.runAsyncTimer(() -> this.fPlayerService.getOnlineFPlayers().forEach(this::send), ticker.getPeriod());
        }
        this.listenerRegistry.register(PlayerlistnamePulseListener.class);
    }

    @Override
    public MessageType messageType() {
        return MessageType.PLAYERLISTNAME;
    }

    @Override
    public Message.Tab.Playerlistname config() {
        return this.fileResolver.getMessage().getTab().getPlayerlistname();
    }

    @Override
    public Permission.Message.Tab.Playerlistname permission() {
        return this.fileResolver.getPermission().getMessage().getTab().getPlayerlistname();
    }

    @Override
    public Localization.Message.Tab.Playerlistname localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getTab().getPlayerlistname();
    }

    @Async
    public void update() {
        if (!this.isEnable()) {
            return;
        }
        this.fPlayerService.getPlatformFPlayers().forEach(this::send);
    }

    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (!this.platformPlayerAdapter.isOnline(fPlayer)) {
            return;
        }
        this.fPlayerService.getFPlayersWhoCanSee(fPlayer).forEach(fReceiver -> this.updatePlayerlistname(fPlayer, (FPlayer)fReceiver));
    }

    public void add(UUID uuid) {
        if (!this.isProxyMode()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(uuid);
        if (this.platformPlayerAdapter.isOnline(fPlayer)) {
            return;
        }
        UserProfile userProfile = this.createUserProfile(fPlayer);
        this.fPlayerService.getOnlineFPlayers().stream().filter(fReceiver -> this.integrationModule.canSeeVanished(fPlayer, (FEntity)fReceiver)).forEach(fReceiver -> this.packetSender.send((FPlayer)fReceiver, (PacketWrapper<?>)new WrapperPlayServerPlayerInfoUpdate(ADD_ACTIONS, new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{this.createPlayerInfo(fPlayer, (FPlayer)fReceiver, userProfile)})));
    }

    public void remove(UUID uuid) {
        if (!this.isProxyMode()) {
            return;
        }
        this.platformPlayerAdapter.getOnlinePlayers().forEach(onlineUUID -> this.packetSender.send((UUID)onlineUUID, (PacketWrapper<?>)new WrapperPlayServerPlayerInfoRemove(new UUID[]{uuid})));
    }

    private void updatePlayerlistname(FPlayer fPlayer, FPlayer fReceiver) {
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return;
        }
        Component name = this.buildFPlayerName(fPlayer, fReceiver);
        if (this.packetProvider.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_19_4)) {
            List<WrapperPlayServerPlayerInfoUpdate.PlayerInfo> proxyPlayersInfo;
            if (this.isProxyMode() && !(proxyPlayersInfo = this.getProxyPlayerInfos(fReceiver)).isEmpty()) {
                this.packetSender.send(fReceiver, (PacketWrapper<?>)new WrapperPlayServerPlayerInfoUpdate(ADD_ACTIONS, proxyPlayersInfo));
            }
            WrapperPlayServerPlayerInfoUpdate.PlayerInfo playerInfo = new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(user.getProfile(), true, this.fPlayerService.getPing(fPlayer), this.platformPlayerAdapter.getGamemode(fPlayer), name, null);
            this.packetSender.send(fReceiver, (PacketWrapper<?>)new WrapperPlayServerPlayerInfoUpdate(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_DISPLAY_NAME, new WrapperPlayServerPlayerInfoUpdate.PlayerInfo[]{playerInfo}));
            return;
        }
        WrapperPlayServerPlayerInfo.PlayerData playerData = new WrapperPlayServerPlayerInfo.PlayerData(name, user.getProfile(), this.platformPlayerAdapter.getGamemode(fPlayer), this.fPlayerService.getPing(fPlayer));
        this.packetSender.send(fReceiver, (PacketWrapper<?>)new WrapperPlayServerPlayerInfo(WrapperPlayServerPlayerInfo.Action.UPDATE_DISPLAY_NAME, new WrapperPlayServerPlayerInfo.PlayerData[]{playerData}));
    }

    public boolean isProxyMode() {
        return this.config().isProxyMode() && this.proxyRegistry.hasEnabledProxy();
    }

    private List<WrapperPlayServerPlayerInfoUpdate.PlayerInfo> getProxyPlayerInfos(FPlayer fReceiver) {
        List<UUID> currentServerPlayers = this.platformPlayerAdapter.getOnlinePlayers();
        return this.fPlayerService.findOnlineFPlayers().stream().filter(fPlayer -> !currentServerPlayers.contains(fPlayer.getUuid())).filter(fPlayer -> this.integrationModule.canSeeVanished((FEntity)fPlayer, fReceiver)).map(fPlayer -> this.createPlayerInfo((FPlayer)fPlayer, fReceiver, null)).toList();
    }

    private Component buildFPlayerName(FPlayer fPlayer, FPlayer fReceiver) {
        boolean offlineClient = fPlayer.getUuid().version() == 3;
        return this.messagePipeline.builder(fPlayer, fReceiver, this.localization(fReceiver).getFormat()).flag(MessageFlag.OBJECT_PLAYER_HEAD, offlineClient).build();
    }

    private WrapperPlayServerPlayerInfoUpdate.PlayerInfo createPlayerInfo(FPlayer fPlayer, FPlayer fReceiver, @Nullable UserProfile userProfile) {
        if (userProfile == null) {
            userProfile = this.createUserProfile(fPlayer);
        }
        return new WrapperPlayServerPlayerInfoUpdate.PlayerInfo(userProfile, true, -1, GameMode.SURVIVAL, this.buildFPlayerName(fPlayer, fReceiver), null);
    }

    private UserProfile createUserProfile(FPlayer fPlayer) {
        if (fPlayer.getSettingsText().isEmpty()) {
            this.fPlayerService.loadSettings(fPlayer);
        }
        if (!this.scoreboardModule.hasTeam(fPlayer)) {
            this.scoreboardModule.create(fPlayer, true);
        }
        PlayerHeadObjectContents.ProfileProperty profileProperty = this.skinService.getProfilePropertyFromCache(fPlayer);
        List<TextureProperty> textureProperties = List.of(new TextureProperty(profileProperty.name(), profileProperty.value(), profileProperty.signature()));
        return new UserProfile(fPlayer.getUuid(), fPlayer.getName(), textureProperties);
    }

    @Inject
    @Generated
    public PlayerlistnameModule(FileResolver fileResolver, FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, MessagePipeline messagePipeline, PacketSender packetSender, PacketProvider packetProvider, TaskScheduler taskScheduler, ListenerRegistry listenerRegistry, SkinService skinService, ProxyRegistry proxyRegistry, ScoreboardModule scoreboardModule, IntegrationModule integrationModule) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.messagePipeline = messagePipeline;
        this.packetSender = packetSender;
        this.packetProvider = packetProvider;
        this.taskScheduler = taskScheduler;
        this.listenerRegistry = listenerRegistry;
        this.skinService = skinService;
        this.proxyRegistry = proxyRegistry;
        this.scoreboardModule = scoreboardModule;
        this.integrationModule = integrationModule;
    }
}

