/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.update;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.message.update.listener.UpdatePulseListener;
import net.flectone.pulse.module.message.update.model.UpdateMessageMetadata;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class UpdateModule
extends AbstractModuleLocalization<Localization.Message.Update> {
    private final FileResolver fileResolver;
    private final ListenerRegistry listenerRegistry;
    private final Gson gson;
    private String latestVersion;

    @Override
    public void onEnable() {
        super.onEnable();
        this.createSound(this.config().getSound(), this.permission().getSound());
        this.listenerRegistry.register(UpdatePulseListener.class);
        this.checkAndUpdateLatestVersion();
    }

    @Override
    public MessageType messageType() {
        return MessageType.UPDATE;
    }

    @Override
    public Message.Update config() {
        return this.fileResolver.getMessage().getUpdate();
    }

    @Override
    public Permission.Message.Update permission() {
        return this.fileResolver.getPermission().getMessage().getUpdate();
    }

    @Override
    public Localization.Message.Update localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getMessage().getUpdate();
    }

    @Async
    public void send(FPlayer fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return;
        }
        if (this.latestVersion == null) {
            return;
        }
        String currentVersion = this.fileResolver.getConfig().getVersion();
        if (!this.fileResolver.isVersionOlderThan(currentVersion, this.latestVersion)) {
            return;
        }
        this.sendMessage(((UpdateMessageMetadata.UpdateMessageMetadataBuilder)((UpdateMessageMetadata.UpdateMessageMetadataBuilder)((EventMetadata.EventMetadataBuilder)((UpdateMessageMetadata.UpdateMessageMetadataBuilder)((UpdateMessageMetadata.UpdateMessageMetadataBuilder)((UpdateMessageMetadata.UpdateMessageMetadataBuilder)UpdateMessageMetadata.builder().sender(fPlayer)).format((fResolver, s) -> StringUtils.replaceEach((String)(fResolver.isUnknown() ? s.getFormatConsole() : s.getFormatPlayer()), (String[])new String[]{"<current_version>", "<latest_version>"}, (String[])new String[]{String.valueOf(currentVersion), String.valueOf(this.latestVersion)}))).currentVersion(currentVersion)).latestVersion(this.latestVersion)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Async
    public void checkAndUpdateLatestVersion() {
        HttpClient client = HttpClient.newHttpClient();
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/Flectone/FlectonePulse/releases/latest")).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return;
            }
            LatestRelease latestRelease = (LatestRelease)this.gson.fromJson(response.body(), LatestRelease.class);
            this.latestVersion = Strings.CS.replace(latestRelease.tagName, "v", "");
            this.send(FPlayer.UNKNOWN);
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
    }

    @Inject
    @Generated
    public UpdateModule(FileResolver fileResolver, ListenerRegistry listenerRegistry, Gson gson) {
        this.fileResolver = fileResolver;
        this.listenerRegistry = listenerRegistry;
        this.gson = gson;
    }

    private static class LatestRelease {
        @SerializedName(value="tag_name")
        public String tagName;

        private LatestRelease() {
        }
    }
}

