/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.message.vanilla.extractor;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.ComponentLike;
import net.flectone.pulse.library.adventure.text.TextComponent;
import net.flectone.pulse.library.adventure.text.TranslatableComponent;
import net.flectone.pulse.library.adventure.text.TranslationArgument;
import net.flectone.pulse.library.adventure.text.event.HoverEvent;
import net.flectone.pulse.library.adventure.text.format.TextDecoration;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.vanilla.model.Mapping;
import net.flectone.pulse.module.message.vanilla.model.ParsedComponent;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.EntityUtil;

@Singleton
public class Extractor {
    private static final Map<String, Mapping> LEGACY_TRANSLATION_MAPPINGS = new HashMap<String, Mapping>(){
        {
            this.put("commands.setblock.success", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_19_4), "commands.setblock.success", new Mapping(serverVersion -> true, "commands.setblock.success.1_19_4", null)));
            this.put("commands.setworldspawn.success", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9), "commands.setworldspawn.success", new Mapping(serverVersion -> serverVersion.isOlderThanOrEquals(ServerVersion.V_1_16), "commands.setworldspawn.success.1_16", new Mapping(serverVersion -> true, "commands.setworldspawn.success.1_21_8", null))));
            this.put("commands.spawnpoint.success.multiple", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9), "commands.spawnpoint.success.multiple", new Mapping(serverVersion -> serverVersion.isOlderThanOrEquals(ServerVersion.V_1_14_2), "commands.spawnpoint.success.multiple.1_14_2", new Mapping(serverVersion -> true, "commands.spawnpoint.success.multiple.1_21_8", null))));
            this.put("commands.spawnpoint.success.single", new Mapping(serverVersion -> serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9), "commands.spawnpoint.success.single", new Mapping(serverVersion -> serverVersion.isOlderThanOrEquals(ServerVersion.V_1_14_2), "commands.spawnpoint.success.single.1_14_2", new Mapping(serverVersion -> true, "commands.spawnpoint.success.single.1_21_8", null))));
        }
    };
    private final Map<String, Message.Vanilla.VanillaMessage> translationVanillaMessages = new HashMap<String, Message.Vanilla.VanillaMessage>();
    private final EntityUtil entityUtil;
    private final FPlayerService fPlayerService;
    private final FileResolver fileResolver;
    private final PacketProvider packetProvider;

    public void reload() {
        this.translationVanillaMessages.clear();
        List<Message.Vanilla.VanillaMessage> vanillaMessages = this.fileResolver.getMessage().getVanilla().getTypes();
        vanillaMessages.forEach(vanillaMessage -> vanillaMessage.getTranslationKeys().forEach(translationKey -> this.translationVanillaMessages.put((String)translationKey, (Message.Vanilla.VanillaMessage)vanillaMessage)));
    }

    public String getOrLegacyMapping(String translationKey) {
        Mapping mapping = LEGACY_TRANSLATION_MAPPINGS.get(translationKey);
        if (mapping == null) {
            return translationKey;
        }
        return this.recursiveGetTranslationKey(mapping);
    }

    private String recursiveGetTranslationKey(Mapping mapping) {
        ServerVersion currentServerVersion = this.packetProvider.getServerVersion();
        if (mapping.predicate().test(currentServerVersion)) {
            return mapping.newTranslationKey();
        }
        Mapping nextMapping = mapping.orElse();
        if (nextMapping == null) {
            return "";
        }
        return this.recursiveGetTranslationKey(mapping.orElse());
    }

    public Message.Vanilla.VanillaMessage getVanillaMessage(String translationKey) {
        return this.translationVanillaMessages.getOrDefault(translationKey, new Message.Vanilla.VanillaMessage());
    }

    public Optional<ParsedComponent> extract(TranslatableComponent translatableComponent) {
        String translationKey = this.getOrLegacyMapping(translatableComponent.key());
        Map<String, String> localization = this.fileResolver.getLocalization().getMessage().getVanilla().getTypes();
        if (!localization.containsKey(translationKey)) {
            return Optional.empty();
        }
        Message.Vanilla.VanillaMessage vanillaMessage = this.getVanillaMessage(translationKey);
        HashMap<Integer, Object> parsedArguments = new HashMap<Integer, Object>();
        for (int i = 0; i < translatableComponent.arguments().size(); ++i) {
            Optional<FEntity> entity = this.extractFEntity(translatableComponent, i);
            if (entity.isEmpty() || entity.get().isUnknown() && entity.get().getShowEntityName() == null) {
                Optional<Component> component = this.getComponent(translatableComponent, i);
                parsedArguments.put(i, component.orElse((Component)Component.empty()));
                continue;
            }
            parsedArguments.put(i, entity.get());
        }
        ParsedComponent parsedComponent = new ParsedComponent(translationKey, vanillaMessage, parsedArguments);
        return Optional.of(parsedComponent);
    }

    public Optional<FEntity> extractFEntity(TranslatableComponent translatableComponent, int index) {
        Optional<Component> component = this.getComponent(translatableComponent, index, Component.class);
        if (component.isEmpty()) {
            return Optional.empty();
        }
        return this.extractFEntity(component.get());
    }

    public Optional<FEntity> extractFEntity(Component component) {
        HoverEvent hoverEvent = component.hoverEvent();
        if (hoverEvent == null && !component.children().isEmpty()) {
            hoverEvent = ((Component)J_U_List.getFirst(component.children())).hoverEvent();
        }
        if (hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hoverEvent.value();
            UUID uuid = showEntity.id();
            String rawType = showEntity.type().key().value();
            if (rawType.equals("player")) {
                return Optional.of(this.fPlayerService.getFPlayer(uuid));
            }
            String type = this.entityUtil.resolveEntityTranslationKey(rawType);
            FEntity fEntity = new FEntity("UNKNOWN_FLECTONEPULSE", uuid, type);
            fEntity.setShowEntityName(showEntity.name());
            return Optional.of(fEntity);
        }
        Optional<String> optionalName = this.extractTextContentOrTranslatableKey(component);
        if (optionalName.isEmpty()) {
            return Optional.empty();
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(optionalName.get());
        return ((FEntity)fPlayer).isUnknown() ? Optional.empty() : Optional.of(fPlayer);
    }

    protected <T extends ComponentLike> Optional<T> parseComponent(Component component, Class<T> clazz) {
        if (clazz.isInstance(component)) {
            return Optional.of((ComponentLike)clazz.cast(component));
        }
        return Optional.empty();
    }

    protected <T extends ComponentLike> Optional<T> getComponent(TranslatableComponent translatableComponent, int index, Class<T> clazz) {
        List translationArguments = translatableComponent.arguments();
        if (index < translationArguments.size()) {
            return this.parseComponent(((TranslationArgument)translationArguments.get(index)).asComponent(), clazz);
        }
        return Optional.empty();
    }

    protected Optional<Component> getComponent(TranslatableComponent translatableComponent, int index) {
        return this.getComponent(translatableComponent, index, Component.class);
    }

    public Component getValueComponent(Component component) {
        Optional<Object> optional;
        Component component2 = component;
        Objects.requireNonNull(component2);
        Component component3 = component2;
        int n = 0;
        block5: while (true) {
            switch (Extractor.jvmdowngrader$switch$getValueComponent$0(component3, n)) {
                case 0: {
                    TranslatableComponent valueTranslatableComponent = (TranslatableComponent)component3;
                    if (valueTranslatableComponent.arguments().isEmpty()) {
                        n = 1;
                        continue block5;
                    }
                    optional = Optional.of(((TranslationArgument)J_U_List.getFirst(valueTranslatableComponent.arguments())).asComponent());
                    break block5;
                }
                case 1: {
                    TextComponent valueTextComponent = (TextComponent)component3;
                    if (valueTextComponent.children().isEmpty()) {
                        n = 2;
                        continue block5;
                    }
                    optional = Optional.of(((Component)J_U_List.getFirst(valueTextComponent.children())).asComponent());
                    break block5;
                }
                case 2: {
                    TextComponent valueTextComponent = (TextComponent)component3;
                    optional = Optional.of(valueTextComponent);
                    break block5;
                }
                default: {
                    optional = Optional.empty();
                    break block5;
                }
            }
            break;
        }
        Optional<Component> component1 = optional;
        return component1.map(this::recursiveExtractValueComponent).orElseGet(Component::empty);
    }

    private Component recursiveExtractValueComponent(Component valueComponent) {
        TranslatableComponent valueTranslatableComponent;
        TextComponent valueTextComponent;
        if (!valueComponent.style().hasDecoration(TextDecoration.ITALIC) && valueComponent instanceof TextComponent && (valueTextComponent = (TextComponent)valueComponent).content().isEmpty() && !valueTextComponent.children().isEmpty()) {
            return this.recursiveExtractValueComponent((Component)J_U_List.getFirst(valueTextComponent.children()));
        }
        if (valueComponent instanceof TranslatableComponent && (valueTranslatableComponent = (TranslatableComponent)valueComponent).key().equals("chat.square_brackets") && !valueTranslatableComponent.arguments().isEmpty()) {
            return this.recursiveExtractValueComponent(((TranslationArgument)J_U_List.getFirst(valueTranslatableComponent.arguments())).asComponent());
        }
        return valueComponent;
    }

    protected Optional<String> extractTextContentOrTranslatableKey(Component component) {
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            String content = textComponent.content();
            if (!StringUtils.isEmpty((CharSequence)content)) {
                return Optional.of(content);
            }
            String insertion = textComponent.insertion();
            return insertion == null ? Optional.of("") : Optional.of(insertion);
        }
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)component;
            String key = translatableComponent.key();
            return Optional.of(key);
        }
        return Optional.empty();
    }

    @Inject
    @Generated
    public Extractor(EntityUtil entityUtil, FPlayerService fPlayerService, FileResolver fileResolver, PacketProvider packetProvider) {
        this.entityUtil = entityUtil;
        this.fPlayerService = fPlayerService;
        this.fileResolver = fileResolver;
        this.packetProvider = packetProvider;
    }

    private static /* synthetic */ int jvmdowngrader$switch$getValueComponent$0(Object object, int n) {
        int n2;
        if (n < 0 || n >= 3) {
            throw new IndexOutOfBoundsException("Index " + n + " out of bounds for length " + 3);
        }
        if (object == null) {
            n2 = -1;
        } else {
            switch (n) {
                case 0: {
                    if (object instanceof TranslatableComponent) {
                        n2 = 0;
                        break;
                    }
                }
                case 1: {
                    if (object instanceof TextComponent) {
                        n2 = 1;
                        break;
                    }
                }
                case 2: {
                    if (object instanceof TextComponent) {
                        n2 = 2;
                        break;
                    }
                }
                default: {
                    n2 = 3;
                }
            }
        }
        return n2;
    }
}

