/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.adapter;

import bukkit-downgraded.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.object.PlayerHeadObjectContents;
import net.flectone.pulse.library.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.impl.util.SpigotConversionUtil;
import net.flectone.pulse.library.packetevents.protocol.player.GameMode;
import net.flectone.pulse.library.packetevents.protocol.player.User;
import net.flectone.pulse.library.packetevents.protocol.potion.PotionType;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.message.objective.ObjectiveModule;
import net.flectone.pulse.module.message.tab.footer.FooterModule;
import net.flectone.pulse.module.message.tab.header.HeaderModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.provider.AttributesProvider;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.provider.PassengersProvider;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class BukkitPlayerAdapter
implements PlatformPlayerAdapter {
    private final Injector injector;
    private final PacketProvider packetProvider;
    private final AttributesProvider attributesProvider;
    private final PassengersProvider passengersProvider;
    private final ReflectionResolver reflectionResolver;
    private MethodHandle handleMethod;
    private MethodHandle gameProfileMethod;
    private MethodHandle propertiesMethod;
    private boolean gameProfileMethodsInitialized;

    private void initGameProfileMethods(Player player) {
        this.gameProfileMethodsInitialized = true;
        try {
            this.handleMethod = this.reflectionResolver.unreflectMethod(player.getClass().getMethod("getHandle", new Class[0]));
            if (this.handleMethod == null) {
                return;
            }
            Object entityPlayer = this.handleMethod.invoke(player);
            this.gameProfileMethod = this.reflectionResolver.unreflectMethod(entityPlayer.getClass().getMethod("getGameProfile", new Class[0]));
            if (this.gameProfileMethod == null) {
                return;
            }
            Object gameProfile = this.gameProfileMethod.invoke(entityPlayer);
            try {
                this.propertiesMethod = this.reflectionResolver.unreflectMethod(gameProfile.getClass().getMethod("properties", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                this.propertiesMethod = this.reflectionResolver.unreflectMethod(gameProfile.getClass().getMethod("getProperties", new Class[0]));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    @Nullable
    public Object convertToPlatformPlayer(@NotNull FPlayer fPlayer) {
        return this.convertToPlatformPlayer(fPlayer.getUuid());
    }

    @Override
    @Nullable
    public Object convertToPlatformPlayer(@NotNull UUID uuid) {
        return Bukkit.getPlayer((UUID)uuid);
    }

    @Override
    public int getEntityId(@NotNull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return player != null ? player.getEntityId() : 0;
    }

    @Override
    @Nullable
    public UUID getPlayerByEntityId(int entityId) {
        return Bukkit.getOnlinePlayers().stream().filter(player -> player.getEntityId() == entityId).findFirst().map(Entity::getUniqueId).orElse(null);
    }

    @Override
    @NotNull
    public Class<?> getPlayerClass() {
        return Player.class;
    }

    @Override
    @Nullable
    public UUID getUUID(@NotNull Object player) {
        UUID uUID;
        if (player instanceof Entity) {
            Entity entity = (Entity)player;
            uUID = entity.getUniqueId();
        } else {
            uUID = null;
        }
        return uUID;
    }

    @Override
    @NotNull
    public String getName(@NotNull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        return player != null ? player.getName() : "";
    }

    @Override
    @NotNull
    public String getName(@NotNull Object player) {
        String string;
        if (player instanceof CommandSender) {
            CommandSender commandSender = (CommandSender)player;
            string = commandSender.getName();
        } else {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public String getWorldName(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        return player != null ? player.getWorld().getName() : "";
    }

    @Override
    @NotNull
    public String getWorldEnvironment(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        return player != null ? player.getWorld().getEnvironment().toString().toLowerCase() : "";
    }

    @Override
    @Nullable
    public String getIp(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player != null) {
            return this.packetProvider.getHostAddress(player.getAddress());
        }
        User user = this.packetProvider.getUser(fPlayer);
        if (user == null) {
            return null;
        }
        return this.packetProvider.getHostAddress(user.getAddress());
    }

    @Override
    @NotNull
    public String getEntityTranslationKey(@Nullable Object platformPlayer) {
        if (platformPlayer instanceof Entity) {
            Entity entity = (Entity)platformPlayer;
            return entity.getType().getTranslationKey();
        }
        return "";
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull UUID uuid) {
        Entity entity = Bukkit.getEntity((UUID)uuid);
        return this.getEntityTranslationKey(entity);
    }

    @Override
    @NotNull
    public GameMode getGamemode(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        return player != null ? SpigotConversionUtil.fromBukkitGameMode((org.bukkit.GameMode)player.getGameMode()) : GameMode.SURVIVAL;
    }

    @Override
    public PlayerHeadObjectContents.ProfileProperty getTexture(@NotNull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        if (!this.gameProfileMethodsInitialized) {
            this.initGameProfileMethods(player);
        }
        try {
            Object entityPlayer = this.handleMethod.invoke(player);
            GameProfile profile = this.gameProfileMethod.invoke(entityPlayer);
            PropertyMap properties = this.propertiesMethod.invoke(profile);
            Collection textures = properties.get((Object)"textures");
            if (textures == null || textures.isEmpty()) {
                return null;
            }
            Property textureProperty = (Property)textures.iterator().next();
            return PlayerHeadObjectContents.property((String)"textures", (String)textureProperty.getValue(), (String)textureProperty.getSignature());
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Override
    public boolean hasPlayedBefore(@NotNull FPlayer fPlayer) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)fPlayer.getUuid());
        return offlinePlayer.hasPlayedBefore();
    }

    @Override
    public boolean hasPotionEffect(@NotNull FEntity fEntity, @NotNull PotionType potionType) {
        Player player = Bukkit.getPlayer((UUID)fEntity.getUuid());
        if (player == null) {
            return false;
        }
        return player.hasPotionEffect(SpigotConversionUtil.toBukkitPotionEffectType((PotionType)potionType));
    }

    @Override
    public boolean isOnline(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return false;
        }
        return player.isOnline();
    }

    @Override
    public boolean isConsole(@NotNull Object player) {
        return player instanceof ConsoleCommandSender;
    }

    @Override
    public boolean isSneaking(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return false;
        }
        return player.isSneaking();
    }

    @Override
    public long getFirstPlayed(@NotNull FPlayer fPlayer) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)fPlayer.getUuid());
        return player.getFirstPlayed();
    }

    @Override
    public long getLastPlayed(@NotNull FPlayer fPlayer) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)fPlayer.getUuid());
        return player.getLastPlayed();
    }

    @Override
    public long getAllTimePlayed(@NotNull FPlayer fPlayer) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)fPlayer.getUuid());
        return (long)player.getStatistic(Statistic.PLAY_ONE_MINUTE) * 50L;
    }

    @Override
    @NotNull
    public Component getPlayerListHeader(@NotNull FPlayer fPlayer) {
        String header;
        HeaderModule headerModule = (HeaderModule)this.injector.getInstance(HeaderModule.class);
        if (!headerModule.isModuleDisabledFor(fPlayer) && (header = headerModule.getCurrentMessage(fPlayer)) != null) {
            return ((MessagePipeline)this.injector.getInstance(MessagePipeline.class)).builder(fPlayer, header).build();
        }
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return Component.empty();
        }
        header = player.getPlayerListHeader();
        if (header == null) {
            return Component.empty();
        }
        return LegacyComponentSerializer.legacySection().deserialize(header);
    }

    @Override
    @NotNull
    public Component getPlayerListFooter(@NotNull FPlayer fPlayer) {
        String footer;
        FooterModule footerModule = (FooterModule)this.injector.getInstance(FooterModule.class);
        if (!footerModule.isModuleDisabledFor(fPlayer) && (footer = footerModule.getCurrentMessage(fPlayer)) != null) {
            return ((MessagePipeline)this.injector.getInstance(MessagePipeline.class)).builder(fPlayer, footer).build();
        }
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return Component.empty();
        }
        footer = player.getPlayerListFooter();
        if (footer == null) {
            return Component.empty();
        }
        return LegacyComponentSerializer.legacySection().deserialize(footer);
    }

    @Override
    public int getObjectiveScore(@NotNull UUID uuid, @Nullable ObjectiveModule.Mode objectiveValueType) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return 0;
        }
        if (objectiveValueType == null) {
            return 0;
        }
        return switch (objectiveValueType) {
            default -> throw new J_L_MatchException(null, null);
            case ObjectiveModule.Mode.HEALTH -> (int)Math.round(player.getHealth() * 10.0) / 10;
            case ObjectiveModule.Mode.LEVEL -> player.getLevel();
            case ObjectiveModule.Mode.FOOD -> player.getFoodLevel();
            case ObjectiveModule.Mode.PING -> this.packetProvider.getPing(player);
            case ObjectiveModule.Mode.ARMOR -> (int)this.attributesProvider.getArmorValue(player);
            case ObjectiveModule.Mode.ATTACK -> (int)this.attributesProvider.getAttackDamage(player);
        };
    }

    @Override
    public PlatformPlayerAdapter.Statistics getStatistics(@NotNull FEntity fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return null;
        }
        return new PlatformPlayerAdapter.Statistics((double)Math.round(player.getHealth() * 10.0) / 10.0, this.attributesProvider.getArmorValue(player), player.getLevel(), player.getFoodLevel(), this.attributesProvider.getAttackDamage(player));
    }

    @Override
    public double distance(@NotNull FPlayer first, @NotNull FPlayer second) {
        if (first.equals(second)) {
            return 0.0;
        }
        Player firstPlayer = Bukkit.getPlayer((UUID)first.getUuid());
        if (firstPlayer == null) {
            return -1.0;
        }
        Player secondPlayer = Bukkit.getPlayer((UUID)second.getUuid());
        if (secondPlayer == null) {
            return -1.0;
        }
        World world = firstPlayer.getLocation().getWorld();
        if (world == null) {
            return -1.0;
        }
        if (!world.equals((Object)secondPlayer.getLocation().getWorld())) {
            return -1.0;
        }
        return firstPlayer.getLocation().distance(secondPlayer.getLocation());
    }

    @Override
    public PlatformPlayerAdapter.Coordinates getCoordinates(@NotNull FEntity fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return null;
        }
        Location location = player.getLocation();
        return new PlatformPlayerAdapter.Coordinates(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public @Nullable net.flectone.pulse.library.packetevents.protocol.world.Location getLocation(@NotNull FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return null;
        }
        return SpigotConversionUtil.fromBukkitLocation((Location)player.getLocation());
    }

    @Override
    public Object getItem(@NotNull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        PlayerInventory playerInventory = player.getInventory();
        try {
            PlayerInventory.class.getMethod("getItemInMainHand", new Class[0]);
            return playerInventory.getItemInMainHand().getType() == Material.AIR ? playerInventory.getItemInOffHand() : playerInventory.getItemInMainHand();
        }
        catch (NoSuchMethodException e) {
            return playerInventory.getItemInHand();
        }
    }

    @Override
    public void updateInventory(@NotNull UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return;
        }
        player.updateInventory();
    }

    @Override
    @NotNull
    public List<UUID> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(Entity::getUniqueId).toList();
    }

    @Override
    @NotNull
    public Set<UUID> findPlayersWhoCanSee(FPlayer fPlayer, double x, double y, double z) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return Collections.emptySet();
        }
        World world = player.getWorld();
        Location location = player.getLocation();
        return world.getNearbyEntities(location, x, y, z).stream().filter(Player.class::isInstance).map(Player.class::cast).filter(target -> target.canSee(player)).map(Entity::getUniqueId).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public List<Integer> getPassengers(FPlayer fPlayer) {
        Player player = Bukkit.getPlayer((UUID)fPlayer.getUuid());
        if (player == null) {
            return Collections.emptyList();
        }
        return this.passengersProvider.getPassengers(player);
    }

    @Override
    @NotNull
    public List<PlatformPlayerAdapter.PlayedTimePlayer> getPlayedTimePlayers() {
        return Arrays.stream(Bukkit.getOfflinePlayers()).filter(offlinePlayer -> offlinePlayer.getName() != null).map(offlinePlayer -> new PlatformPlayerAdapter.PlayedTimePlayer(offlinePlayer.getName(), (long)offlinePlayer.getStatistic(Statistic.PLAY_ONE_MINUTE) * 50L)).toList();
    }

    @Inject
    @Generated
    public BukkitPlayerAdapter(Injector injector, PacketProvider packetProvider, AttributesProvider attributesProvider, PassengersProvider passengersProvider, ReflectionResolver reflectionResolver) {
        this.injector = injector;
        this.packetProvider = packetProvider;
        this.attributesProvider = attributesProvider;
        this.passengersProvider = passengersProvider;
        this.reflectionResolver = reflectionResolver;
    }
}

