/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.protocol.item.ItemStack;
import net.flectone.pulse.library.packetevents.wrapper.PacketWrapper;
import net.flectone.pulse.library.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerCloseWindow;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerWindowItems;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.inventory.ClickType;
import net.flectone.pulse.model.inventory.Inventory;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.sender.PacketSender;

@Singleton
public class InventoryController {
    private final Map<UUID, Inventory> inventoryMap = new ConcurrentHashMap<UUID, Inventory>();
    private final PacketSender packetSender;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    public Inventory get(UUID uuid) {
        return this.inventoryMap.get(uuid);
    }

    public void close(UUID uuid) {
        Inventory inventory = this.inventoryMap.get(uuid);
        if (inventory == null) {
            return;
        }
        inventory.getCloseConsumerList().forEach(closeConsumer -> closeConsumer.accept(inventory));
        this.inventoryMap.remove(uuid);
    }

    public void closeAll() {
        WrapperPlayServerCloseWindow wrapper = new WrapperPlayServerCloseWindow();
        this.inventoryMap.keySet().forEach(uuid -> this.packetSender.send((UUID)uuid, (PacketWrapper<?>)wrapper));
        this.inventoryMap.clear();
    }

    public void open(FPlayer fPlayer, Inventory inventory) {
        this.inventoryMap.put(fPlayer.getUuid(), inventory);
        this.packetSender.send(fPlayer, (PacketWrapper<?>)inventory.getWrapperWindow());
        this.packetSender.send(fPlayer, (PacketWrapper<?>)inventory.getWrapperItems());
    }

    public void click(Inventory inventory, int slot) {
        if (!inventory.getClickConsumerMap().containsKey(slot)) {
            return;
        }
        ItemStack itemStack = (ItemStack)inventory.getWrapperItems().getItems().get(slot);
        inventory.getClickConsumerMap().get(slot).accept(itemStack, inventory);
    }

    @Async
    public void process(UUID uuid, WrapperPlayClientClickWindow wrapper) {
        ClickType clickType;
        Inventory inventory = this.inventoryMap.get(uuid);
        boolean isWindowClicked = this.isWindowClick(inventory, clickType = this.getClickType(wrapper), wrapper);
        if (isWindowClicked || clickType == ClickType.PICKUP) {
            this.packetSender.send(uuid, (PacketWrapper<?>)new WrapperPlayServerWindowItems(wrapper.getWindowId(), 0, inventory.getWrapperItems().getItems(), null));
            if (isWindowClicked) {
                this.click(inventory, wrapper.getSlot());
            }
        }
        this.platformPlayerAdapter.updateInventory(uuid);
    }

    public void changeItem(FPlayer fPlayer, Inventory inventory, int slot, ItemStack newItemStack) {
        List itemStacks = inventory.getWrapperItems().getItems();
        itemStacks.set(slot, newItemStack);
        WrapperPlayServerWindowItems wrapper = inventory.getWrapperItems();
        wrapper.setItems(itemStacks);
        inventory.setWrapperItems(wrapper);
        this.packetSender.send(fPlayer, (PacketWrapper<?>)wrapper);
    }

    public ClickType getClickType(WrapperPlayClientClickWindow wrapper) {
        return switch (wrapper.getWindowClickType()) {
            case WrapperPlayClientClickWindow.WindowClickType.PICKUP -> {
                if (wrapper.getCarriedItemStack() != ItemStack.EMPTY) {
                    yield ClickType.PICKUP;
                }
                yield ClickType.PLACE;
            }
            case WrapperPlayClientClickWindow.WindowClickType.QUICK_MOVE -> ClickType.SHIFT_CLICK;
            case WrapperPlayClientClickWindow.WindowClickType.SWAP -> {
                switch (wrapper.getButton()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 40: {
                        yield ClickType.PICKUP;
                    }
                }
                yield ClickType.PLACE;
            }
            case WrapperPlayClientClickWindow.WindowClickType.CLONE, WrapperPlayClientClickWindow.WindowClickType.THROW -> ClickType.PICKUP;
            case WrapperPlayClientClickWindow.WindowClickType.QUICK_CRAFT -> {
                switch (wrapper.getButton()) {
                    case 0: 
                    case 4: 
                    case 8: {
                        yield ClickType.DRAG_START;
                    }
                    case 1: 
                    case 5: 
                    case 9: {
                        yield ClickType.DRAG_ADD;
                    }
                    case 2: 
                    case 6: 
                    case 10: {
                        yield ClickType.DRAG_END;
                    }
                }
                yield ClickType.UNDEFINED;
            }
            case WrapperPlayClientClickWindow.WindowClickType.PICKUP_ALL -> ClickType.PICKUP_ALL;
            default -> ClickType.UNDEFINED;
        };
    }

    public boolean isWindowClick(Inventory inventory, ClickType clickType, WrapperPlayClientClickWindow wrapper) {
        return switch (clickType) {
            case ClickType.SHIFT_CLICK -> true;
            case ClickType.PICKUP, ClickType.PLACE -> {
                if (wrapper.getSlot() >= 0 && wrapper.getSlot() <= inventory.getSize() - 1) {
                    yield true;
                }
                yield false;
            }
            case ClickType.DRAG_END, ClickType.PICKUP_ALL -> {
                if (wrapper.getSlot() >= 0 && wrapper.getSlot() <= inventory.getSize() - 1 || ((Map)wrapper.getSlots().orElse(new HashMap())).keySet().stream().anyMatch(integer -> integer.intValue() == wrapper.getSlot())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Inject
    @Generated
    public InventoryController(PacketSender packetSender, PlatformPlayerAdapter platformPlayerAdapter) {
        this.packetSender = packetSender;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }
}

