/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.module.ModuleDisableEvent;
import net.flectone.pulse.model.event.module.ModuleEnableEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.module.Module;
import net.flectone.pulse.platform.sender.CooldownSender;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.MuteSender;
import net.flectone.pulse.util.checker.PermissionChecker;

@Singleton
public class ModuleController {
    private final Injector injector;
    private final EventDispatcher eventDispatcher;
    private final PermissionChecker permissionChecker;
    private final DisableSender disableSender;
    private final CooldownSender cooldownSender;
    private final MuteSender muteSender;

    public Map<String, String> collectModuleStatuses() {
        return this.collectModuleStatuses(Module.class);
    }

    public Map<String, String> collectModuleStatuses(Class<? extends AbstractModule> clazz) {
        AbstractModule module = (AbstractModule)this.injector.getInstance(clazz);
        HashMap<String, String> modules = new HashMap<String, String>();
        modules.put(clazz.getSimpleName(), module.isEnable() ? "true" : "false");
        ((AbstractModule)this.injector.getInstance(clazz)).getChildren().forEach(subModule -> modules.putAll(this.collectModuleStatuses((Class<? extends AbstractModule>)subModule)));
        return modules;
    }

    public void reload() {
        this.reload(Module.class);
    }

    public void reload(Class<? extends AbstractModule> clazz) {
        this.configureChildren(clazz);
        this.enable(clazz, module -> module.config().isEnable());
    }

    public void terminate() {
        this.terminate(Module.class);
    }

    public void terminate(Class<? extends AbstractModule> clazz) {
        this.enable(clazz, module -> false);
    }

    public void configureChildren(Class<? extends AbstractModule> clazz) {
        AbstractModule module = (AbstractModule)this.injector.getInstance(clazz);
        module.getChildren().clear();
        module.configureChildren();
        module.getChildren().forEach(this::configureChildren);
    }

    public void enable(Class<? extends AbstractModule> clazz, Predicate<AbstractModule> enablePredicate) {
        AbstractModule module = (AbstractModule)this.injector.getInstance(clazz);
        if (module.isEnable()) {
            ModuleDisableEvent preDisableEvent = new ModuleDisableEvent(module);
            this.eventDispatcher.dispatch(preDisableEvent);
            if (!preDisableEvent.isCancelled()) {
                module.onDisable();
            }
        }
        this.addDefaultPredicates(module);
        module.setEnable(enablePredicate.test(module));
        if (module.isEnable()) {
            ModuleEnableEvent preEnableEvent = new ModuleEnableEvent(module);
            this.eventDispatcher.dispatch(preEnableEvent);
            if (preEnableEvent.isCancelled()) {
                module.setEnable(false);
            } else {
                module.onEnable();
            }
        }
        Predicate<AbstractModule> childPredicate = abstractModule -> module.isEnable() && abstractModule.config().isEnable();
        module.getChildren().forEach(subModule -> this.enable((Class<? extends AbstractModule>)subModule, childPredicate));
    }

    public void addDefaultPredicates(AbstractModule module) {
        module.getPredicates().clear();
        module.addPredicate(fPlayer -> !module.isEnable());
        module.addPredicate(fPlayer -> !this.permissionChecker.check((FEntity)fPlayer, module.getPermission()));
        if (module instanceof AbstractModuleLocalization) {
            AbstractModuleLocalization localizationModule = (AbstractModuleLocalization)module;
            module.addPredicate((fPlayer, needBoolean) -> needBoolean != false && this.disableSender.sendIfDisabled((FEntity)fPlayer, (FEntity)fPlayer, localizationModule.messageType()));
            module.addPredicate((fPlayer, needBoolean) -> needBoolean != false && this.cooldownSender.sendIfCooldown((FEntity)fPlayer, localizationModule.getModuleCooldown()));
            module.addPredicate((fPlayer, needBoolean) -> needBoolean != false && this.muteSender.sendIfMuted((FEntity)fPlayer));
        }
    }

    @Inject
    @Generated
    public ModuleController(Injector injector, EventDispatcher eventDispatcher, PermissionChecker permissionChecker, DisableSender disableSender, CooldownSender cooldownSender, MuteSender muteSender) {
        this.injector = injector;
        this.eventDispatcher = eventDispatcher;
        this.permissionChecker = permissionChecker;
        this.disableSender = disableSender;
        this.cooldownSender = cooldownSender;
        this.muteSender = muteSender;
    }
}

