/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.filter;

import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.util.checker.PermissionChecker;

@Singleton
public class RangeFilter {
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final PermissionChecker permissionChecker;

    public Predicate<FPlayer> createFilter(FPlayer filterPlayer, Range range) {
        FPlayer fPlayer;
        if (range.is(Range.Type.PLAYER)) {
            return filterPlayer::equals;
        }
        if (!(filterPlayer instanceof FPlayer) || (fPlayer = filterPlayer).isUnknown()) {
            return player -> true;
        }
        return fReceiver -> {
            if (fReceiver.isUnknown()) {
                return true;
            }
            if (fReceiver.isIgnored(fPlayer)) {
                return false;
            }
            return switch (range.getType()) {
                case Range.Type.BLOCKS -> this.checkDistance(fPlayer, (FPlayer)fReceiver, range.getValue());
                case Range.Type.WORLD_NAME -> this.checkWorldNamePermission(fPlayer, (FPlayer)fReceiver);
                case Range.Type.WORLD_TYPE -> this.checkWorldTypePermission(fPlayer, (FPlayer)fReceiver);
                default -> true;
            };
        };
    }

    public boolean checkDistance(FPlayer fPlayer, FPlayer fReceiver, int range) {
        double distance = this.platformPlayerAdapter.distance(fPlayer, fReceiver);
        return distance != -1.0 && distance <= (double)range;
    }

    public boolean checkWorldNamePermission(FPlayer fPlayer, FPlayer fReceiver) {
        String worldName = this.platformPlayerAdapter.getWorldName(fPlayer);
        if (worldName.isEmpty()) {
            return true;
        }
        return this.permissionChecker.check((FEntity)fReceiver, "flectonepulse.world.name." + worldName);
    }

    public boolean checkWorldTypePermission(FPlayer fPlayer, FPlayer fReceiver) {
        String worldType = this.platformPlayerAdapter.getWorldEnvironment(fPlayer);
        if (worldType.isEmpty()) {
            return true;
        }
        return this.permissionChecker.check((FEntity)fReceiver, "flectonepulse.world.type." + worldType);
    }

    @Inject
    @Generated
    public RangeFilter(PlatformPlayerAdapter platformPlayerAdapter, PermissionChecker permissionChecker) {
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.permissionChecker = permissionChecker;
    }
}

