/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.formatter;

import java.text.Format;
import java.text.SimpleDateFormat;
import lombok.Generated;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.apache.lang3.time.DurationFormatUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class TimeFormatter {
    public static final long MULTIPLIER = 50L;
    private static final Format SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final FileResolver fileResolver;

    public String format(FPlayer fPlayer, long time) {
        Localization.Time message = this.fileResolver.getLocalization(fPlayer).getTime();
        if (message.getFormat().isEmpty()) {
            return "";
        }
        String formattedTime = DurationFormatUtils.formatDuration((long)time, (String)message.getFormat(), (boolean)false);
        StringBuilder result = new StringBuilder();
        for (String part : formattedTime.split(" ")) {
            if (this.isZeroComponent(part)) continue;
            result.append(this.simplify(part)).append(" ");
        }
        String finalResult = result.toString().trim();
        return finalResult.isEmpty() ? message.getZero() : finalResult;
    }

    private boolean isZeroComponent(String part) {
        int unitIndex;
        for (unitIndex = 0; unitIndex < part.length() && (Character.isDigit(part.charAt(unitIndex)) || part.charAt(unitIndex) == '.') || part.charAt(unitIndex) == ','; ++unitIndex) {
        }
        try {
            double value = Double.parseDouble(part.substring(0, unitIndex));
            return value == 0.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String simplify(String part) {
        int unitIndex;
        for (unitIndex = 0; unitIndex < part.length() && (Character.isDigit(part.charAt(unitIndex)) || part.charAt(unitIndex) == '.') || part.charAt(unitIndex) == ','; ++unitIndex) {
        }
        String numberPart = part.substring(0, unitIndex);
        if (numberPart.contains(".") || numberPart.contains(",")) {
            numberPart = numberPart.replaceAll("0+$", "").replaceAll("[.,]$", "");
        }
        String unit = part.substring(unitIndex);
        return numberPart + unit;
    }

    public String format(FPlayer fPlayer, long time, String message) {
        if (time < 0L) {
            time = 0L;
        }
        return Strings.CS.replace(message, "<time>", this.format(fPlayer, time));
    }

    public String formatDate(long date) {
        return SIMPLE_DATE_FORMAT.format(date);
    }

    @Inject
    @Generated
    public TimeFormatter(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }
}

