/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.formatter;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;

@Singleton
public class UrlFormatter {
    private static final String SAFE_AMPERSAND = "__AND__";

    public String escapeAmpersand(String url) {
        return Strings.CS.replace(url, "&", SAFE_AMPERSAND);
    }

    public String unescapeAmpersand(String url) {
        return Strings.CS.replace(url, SAFE_AMPERSAND, "&");
    }

    public String toASCII(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "";
        }
        try {
            return new URL(url).toURI().toASCIIString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return "";
        }
    }

    @Inject
    @Generated
    public UrlFormatter() {
    }
}

