/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.leangen.geantyref.TypeToken;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.ModerationMetadata;
import net.flectone.pulse.model.event.UnModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.command.anon.AnonModule;
import net.flectone.pulse.module.command.ball.BallModule;
import net.flectone.pulse.module.command.ball.model.BallMetadata;
import net.flectone.pulse.module.command.ban.BanModule;
import net.flectone.pulse.module.command.broadcast.BroadcastModule;
import net.flectone.pulse.module.command.chatcolor.ChatcolorModule;
import net.flectone.pulse.module.command.clearchat.ClearchatModule;
import net.flectone.pulse.module.command.coin.CoinModule;
import net.flectone.pulse.module.command.coin.model.CoinMetadata;
import net.flectone.pulse.module.command.dice.DiceModule;
import net.flectone.pulse.module.command.dice.model.DiceMetadata;
import net.flectone.pulse.module.command.do_.DoModule;
import net.flectone.pulse.module.command.helper.HelperModule;
import net.flectone.pulse.module.command.kick.KickModule;
import net.flectone.pulse.module.command.me.MeModule;
import net.flectone.pulse.module.command.mute.MuteModule;
import net.flectone.pulse.module.command.poll.PollModule;
import net.flectone.pulse.module.command.poll.model.Poll;
import net.flectone.pulse.module.command.poll.model.PollMetadata;
import net.flectone.pulse.module.command.rockpaperscissors.RockpaperscissorsModule;
import net.flectone.pulse.module.command.spy.SpyModule;
import net.flectone.pulse.module.command.spy.model.SpyMetadata;
import net.flectone.pulse.module.command.stream.StreamModule;
import net.flectone.pulse.module.command.stream.model.StreamMetadata;
import net.flectone.pulse.module.command.tell.TellModule;
import net.flectone.pulse.module.command.tictactoe.TictactoeModule;
import net.flectone.pulse.module.command.tictactoe.model.TicTacToe;
import net.flectone.pulse.module.command.tictactoe.service.TictactoeService;
import net.flectone.pulse.module.command.translateto.TranslatetoModule;
import net.flectone.pulse.module.command.translateto.model.TranslatetoMetadata;
import net.flectone.pulse.module.command.try_.TryModule;
import net.flectone.pulse.module.command.try_.model.TryMetadata;
import net.flectone.pulse.module.command.unban.UnbanModule;
import net.flectone.pulse.module.command.unmute.UnmuteModule;
import net.flectone.pulse.module.command.unwarn.UnwarnModule;
import net.flectone.pulse.module.command.warn.WarnModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.afk.AfkModule;
import net.flectone.pulse.module.message.afk.model.AFKMetadata;
import net.flectone.pulse.module.message.chat.ChatModule;
import net.flectone.pulse.module.message.chat.model.ChatMetadata;
import net.flectone.pulse.module.message.format.moderation.delete.DeleteModule;
import net.flectone.pulse.module.message.join.JoinModule;
import net.flectone.pulse.module.message.join.model.JoinMetadata;
import net.flectone.pulse.module.message.quit.QuitModule;
import net.flectone.pulse.module.message.quit.model.QuitMetadata;
import net.flectone.pulse.module.message.tab.playerlist.PlayerlistnameModule;
import net.flectone.pulse.module.message.vanilla.VanillaModule;
import net.flectone.pulse.module.message.vanilla.extractor.Extractor;
import net.flectone.pulse.module.message.vanilla.model.ParsedComponent;
import net.flectone.pulse.module.message.vanilla.model.VanillaMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class ProxyMessageHandler {
    private final Injector injector;
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final FLogger fLogger;
    private final ModerationService moderationService;
    private final Gson gson;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Async
    public void handleProxyMessage(byte[] bytes) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
             DataInputStream input = new DataInputStream(byteStream);){
            MessageType tag = MessageType.fromProxyString(input.readUTF());
            if (tag == null) {
                return;
            }
            switch (tag) {
                case SYSTEM_ONLINE: {
                    this.handleSystemOnline(input);
                    return;
                }
                case SYSTEM_OFFLINE: {
                    this.handleSystemOffline(input);
                    return;
                }
                default: {
                    this.handleTaggedMessage(input, tag);
                    return;
                }
            }
        }
        catch (IOException e) {
            this.fLogger.warning(e);
        }
    }

    private void handleSystemOnline(DataInputStream input) throws IOException {
        UUID uuid = UUID.fromString(input.readUTF());
        this.fPlayerService.invalidateOffline(uuid);
        ((PlayerlistnameModule)this.injector.getInstance(PlayerlistnameModule.class)).add(uuid);
    }

    private void handleSystemOffline(DataInputStream input) throws IOException {
        UUID uuid = UUID.fromString(input.readUTF());
        this.fPlayerService.invalidateOnline(uuid);
        ((PlayerlistnameModule)this.injector.getInstance(PlayerlistnameModule.class)).remove(uuid);
    }

    private void handleTaggedMessage(DataInputStream input, MessageType tag) throws IOException {
        UUID metadataUUID = UUID.fromString(input.readUTF());
        Set proxyClusters = (Set)this.gson.fromJson(input.readUTF(), new TypeToken<Set<String>>(this){}.getType());
        Optional<FEntity> optionalFEntity = this.parseFEntity(this.readAsJsonObject(input));
        if (optionalFEntity.isEmpty()) {
            return;
        }
        FEntity fEntity = optionalFEntity.get();
        if (this.handleModerationInvalidation(tag, fEntity)) {
            return;
        }
        Set<String> configClusters = this.fileResolver.getConfig().getProxy().getClusters();
        if (!configClusters.isEmpty()) {
            if (configClusters.stream().noneMatch(proxyClusters::contains)) {
                return;
            }
        }
        switch (tag) {
            case COMMAND_ANON: {
                this.handleAnonCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_ME: {
                this.handleMeCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_BALL: {
                this.handleBallCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_BAN: {
                this.handleBanCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_BROADCAST: {
                this.handleBroadcastCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_CHATCOLOR: {
                this.handleChatColorCommand(fEntity, metadataUUID);
                break;
            }
            case COMMAND_CHATSETTING: {
                this.handleChatSettingCommand(fEntity);
                break;
            }
            case COMMAND_COIN: {
                this.handleCoinCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_DELETE: {
                this.handleDeleteCommand(input, fEntity);
                break;
            }
            case COMMAND_DICE: {
                this.handleDiceCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_DO: {
                this.handleDoCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_HELPER: {
                this.handleHelperCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_MUTE: {
                this.handleMuteCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_UNBAN: {
                this.handleUnbanCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_UNMUTE: {
                this.handleUnmuteCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_UNWARN: {
                this.handleUnwarnCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_POLL: {
                this.handlePollCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_SPY: {
                this.handleSpyCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_STREAM: {
                this.handleStreamCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_TELL: {
                this.handleTellCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_TRANSLATETO: {
                this.handleTranslateToCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_TRY: {
                this.handleTryCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_WARN: {
                this.handleWarnCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_KICK: {
                this.handleKickCommand(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_TICTACTOE: {
                this.handleTicTacToeCommand(input, fEntity, metadataUUID);
                break;
            }
            case CHAT: {
                this.handleChatMessage(input, fEntity, metadataUUID);
                break;
            }
            case COMMAND_CLEARCHAT: {
                this.handleClearchatCommand(fEntity);
                break;
            }
            case COMMAND_ROCKPAPERSCISSORS: {
                this.handleRockPaperScissors(input, fEntity, metadataUUID);
                break;
            }
            case JOIN: {
                this.handleJoin(input, fEntity, metadataUUID);
                break;
            }
            case QUIT: {
                this.handleQuit(input, fEntity, metadataUUID);
                break;
            }
            case AFK: {
                this.handleAfk(input, fEntity, metadataUUID);
                break;
            }
            case VANILLA: {
                this.handleVanilla(input, fEntity, metadataUUID);
            }
        }
    }

    private boolean handleModerationInvalidation(MessageType tag, FEntity fEntity) {
        return switch (tag) {
            case MessageType.SYSTEM_BAN -> {
                this.moderationService.invalidateBans(fEntity.getUuid());
                yield true;
            }
            case MessageType.SYSTEM_MUTE -> {
                this.moderationService.invalidateMutes(fEntity.getUuid());
                yield true;
            }
            case MessageType.SYSTEM_WARN -> {
                this.moderationService.invalidateWarns(fEntity.getUuid());
                yield true;
            }
            default -> false;
        };
    }

    private void handleAnonCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        AnonModule module = (AnonModule)this.injector.getInstance(AnonModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String message = input.readUTF();
        module.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)module.metadataBuilder().uuid(metadataUUID)).sender(fEntity)).format(Localization.Command.Anon::getFormat)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getAnon().getDestination())).sound(module.getModuleSound())).message(message)).build());
    }

    private void handleMeCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        MeModule module = (MeModule)this.injector.getInstance(MeModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String message = input.readUTF();
        module.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)module.metadataBuilder().uuid(metadataUUID)).sender(fEntity)).format(Localization.Command.Me::getFormat)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getMe().getDestination())).message(message)).sound(module.getModuleSound())).build());
    }

    private void handleBallCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        BallModule module = (BallModule)this.injector.getInstance(BallModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        int answer = input.readInt();
        String message = input.readUTF();
        module.sendMessage(((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((EventMetadata.EventMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)((BallMetadata.BallMetadataBuilder)BallMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.replaceAnswer(answer))).answer(answer)).message(message)).destination(this.fileResolver.getCommand().getBall().getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
    }

    private void handleBanCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        Moderation ban;
        FPlayer fModerator;
        BanModule module = (BanModule)this.injector.getInstance(BanModule.class);
        if (module.isModuleDisabledFor(fModerator = this.fPlayerService.getFPlayer((ban = (Moderation)this.gson.fromJson(input.readUTF(), Moderation.class)).getModerator()))) {
            return;
        }
        module.kick(fModerator, (FPlayer)fEntity, ban);
        module.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.buildFormat(ban))).moderation(ban)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getBan().getDestination())).sound(module.getModuleSound())).build());
    }

    private void handleBroadcastCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        BroadcastModule module = (BroadcastModule)this.injector.getInstance(BroadcastModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String message = input.readUTF();
        module.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)module.metadataBuilder().uuid(metadataUUID)).sender(fEntity)).format(Localization.Command.Broadcast::getFormat)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getBroadcast().getDestination())).message(message)).sound(module.getModuleSound())).build());
    }

    private void handleChatColorCommand(FEntity fEntity, UUID metadataUUID) {
        FPlayer fPlayer = this.fPlayerService.getFPlayer(fEntity.getUuid());
        this.fPlayerService.loadColors(fPlayer);
        ChatcolorModule module = (ChatcolorModule)this.injector.getInstance(ChatcolorModule.class);
        if (!module.isEnable()) {
            return;
        }
        module.sendMessageWithUpdatedColors(fPlayer, metadataUUID);
    }

    private void handleChatSettingCommand(FEntity fEntity) {
        this.fPlayerService.loadSettings(this.fPlayerService.getFPlayer(fEntity.getUuid()));
    }

    private void handleCoinCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        CoinModule module = (CoinModule)this.injector.getInstance(CoinModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        int percent = input.readInt();
        module.sendMessage(((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((EventMetadata.EventMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)((CoinMetadata.CoinMetadataBuilder)CoinMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.replaceResult(percent))).percent(percent)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getCoin().getDestination())).sound(module.getModuleSound())).build());
    }

    private void handleDeleteCommand(DataInputStream input, FEntity fEntity) throws IOException {
        DeleteModule module = (DeleteModule)this.injector.getInstance(DeleteModule.class);
        UUID metadataUUID = UUID.fromString(input.readUTF());
        module.remove(fEntity, metadataUUID);
    }

    private void handleDiceCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        DiceModule module = (DiceModule)this.injector.getInstance(DiceModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        List cubes = (List)this.gson.fromJson(input.readUTF(), new TypeToken<List<Integer>>(this){}.getType());
        module.sendMessage(((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)((DiceMetadata.DiceMetadataBuilder)DiceMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(dice -> module.replaceResult(cubes, dice.getSymbols(), dice.getFormat()))).cubes(cubes)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getDice().getDestination())).sound(module.getModuleSound())).build());
    }

    private void handleDoCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        DoModule module = (DoModule)this.injector.getInstance(DoModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String message = input.readUTF();
        module.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)module.metadataBuilder().uuid(metadataUUID)).sender(fEntity)).format(Localization.Command.Do::getFormat)).message(message)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getDo().getDestination())).sound(module.getModuleSound())).build());
    }

    private void handleHelperCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        HelperModule module = (HelperModule)this.injector.getInstance(HelperModule.class);
        if (!module.isEnable()) {
            return;
        }
        String message = input.readUTF();
        module.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)module.metadataBuilder().uuid(metadataUUID)).sender(fEntity)).format(Localization.Command.Helper::getGlobal)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getHelper().getDestination())).message(message)).sound(module.getModuleSound())).filter(module.getFilterSee())).build());
    }

    private void handleMuteCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        Moderation mute;
        FPlayer fModerator;
        MuteModule module = (MuteModule)this.injector.getInstance(MuteModule.class);
        if (module.isModuleDisabledFor(fModerator = this.fPlayerService.getFPlayer((mute = (Moderation)this.gson.fromJson(input.readUTF(), Moderation.class)).getModerator()))) {
            return;
        }
        module.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.buildFormat(mute))).moderation(mute)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getMute().getDestination())).sound(module.getModuleSound())).build());
        module.sendForTarget(fModerator, (FPlayer)fEntity, mute);
    }

    private void handleUnbanCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        FPlayer fModerator;
        UnbanModule module = (UnbanModule)this.injector.getInstance(UnbanModule.class);
        if (module.isModuleDisabledFor(fModerator = (FPlayer)this.gson.fromJson(input.readUTF(), FPlayer.class))) {
            return;
        }
        List bans = (List)this.gson.fromJson(input.readUTF(), new TypeToken<List<Moderation>>(this){}.getType());
        module.sendMessage(((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)UnModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(unban -> Strings.CS.replace(unban.getFormat(), "<moderator>", fModerator.getName()))).moderator(fModerator)).moderations(bans)).destination(this.fileResolver.getCommand().getUnban().getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
    }

    private void handleUnmuteCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        FPlayer fModerator;
        UnmuteModule module = (UnmuteModule)this.injector.getInstance(UnmuteModule.class);
        if (module.isModuleDisabledFor(fModerator = (FPlayer)this.gson.fromJson(input.readUTF(), FPlayer.class))) {
            return;
        }
        List mutes = (List)this.gson.fromJson(input.readUTF(), new TypeToken<List<Moderation>>(this){}.getType());
        module.sendMessage(((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)UnModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(unwarn -> Strings.CS.replace(unwarn.getFormat(), "<moderator>", fModerator.getName()))).moderator(fModerator)).moderations(mutes)).destination(this.fileResolver.getCommand().getUnmute().getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
    }

    private void handleUnwarnCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        FPlayer fModerator;
        UnwarnModule module = (UnwarnModule)this.injector.getInstance(UnwarnModule.class);
        if (module.isModuleDisabledFor(fModerator = (FPlayer)this.gson.fromJson(input.readUTF(), FPlayer.class))) {
            return;
        }
        List warns = (List)this.gson.fromJson(input.readUTF(), new TypeToken<List<Moderation>>(this){}.getType());
        module.sendMessage(((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)((UnModerationMetadata.UnModerationMetadataBuilder)UnModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(unwarn -> Strings.CS.replace(unwarn.getFormat(), "<moderator>", fModerator.getName()))).moderator(fModerator)).moderations(warns)).destination(this.fileResolver.getCommand().getUnwarn().getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
    }

    private void handlePollCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        PollModule.Action action = PollModule.Action.valueOf(input.readUTF());
        switch (action) {
            case CREATE: {
                PollModule module = (PollModule)this.injector.getInstance(PollModule.class);
                if (module.isModuleDisabledFor(fEntity)) {
                    return;
                }
                Poll poll = (Poll)this.gson.fromJson(input.readUTF(), Poll.class);
                module.saveAndUpdateLast(poll);
                module.sendMessage(((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((EventMetadata.EventMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)((PollMetadata.PollMetadataBuilder)PollMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.resolvePollFormat(fEntity, poll, PollModule.Status.START))).poll(poll)).range(Range.get(Range.Type.SERVER))).message(poll.getTitle())).sound(module.getModuleSound())).build());
                break;
            }
            case VOTE: {
                ((PollModule)this.injector.getInstance(PollModule.class)).vote(fEntity, input.readInt(), input.readInt(), metadataUUID);
            }
        }
    }

    private void handleSpyCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        FPlayer fPlayer;
        SpyModule module = (SpyModule)this.injector.getInstance(SpyModule.class);
        if (!module.isEnable()) {
            return;
        }
        String action = input.readUTF();
        String string = input.readUTF();
        module.sendMessage(((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)SpyMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.replaceAction(action))).turned(true)).action(action)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getSpy().getDestination())).message(string)).filter(module.createFilter(fEntity instanceof FPlayer ? (fPlayer = (FPlayer)fEntity) : FPlayer.UNKNOWN))).build());
    }

    private void handleStreamCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        StreamModule module = (StreamModule)this.injector.getInstance(StreamModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String message = input.readUTF();
        module.sendMessage(((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((EventMetadata.EventMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)((StreamMetadata.StreamMetadataBuilder)StreamMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.replaceUrls(message))).turned(true)).urls(message)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getStream().getDestination())).sound(module.getModuleSound())).build());
    }

    private void handleTellCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        TellModule module = (TellModule)this.injector.getInstance(TellModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        UUID receiverUUID = UUID.fromString(input.readUTF());
        String message = input.readUTF();
        FPlayer fReceiver = this.fPlayerService.getFPlayer(receiverUUID);
        if (fReceiver.isUnknown()) {
            return;
        }
        IntegrationModule integrationModule = (IntegrationModule)this.injector.getInstance(IntegrationModule.class);
        if (!integrationModule.canSeeVanished(fReceiver, fEntity)) {
            return;
        }
        module.send(fEntity, fReceiver, fReceiver, Localization.Command.Tell::getReceiver, message, metadataUUID);
    }

    private void handleTranslateToCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        TranslatetoModule module = (TranslatetoModule)this.injector.getInstance(TranslatetoModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String targetLang = input.readUTF();
        String message = input.readUTF();
        String messageToTranslate = input.readUTF();
        module.sendMessage(((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)((TranslatetoMetadata.TranslatetoMetadataBuilder)TranslatetoMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.replaceLanguage(targetLang))).targetLanguage(targetLang)).messageToTranslate(messageToTranslate)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getTranslateto().getDestination())).message(message)).sound(module.getModuleSound())).build());
    }

    private void handleTryCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        TryModule module = (TryModule)this.injector.getInstance(TryModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        int value = input.readInt();
        String message = input.readUTF();
        module.sendMessage(((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((EventMetadata.EventMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)((TryMetadata.TryMetadataBuilder)TryMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.replacePercent(value))).percent(value)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getTry().getDestination())).message(message)).sound(module.getModuleSound())).build());
    }

    private void handleWarnCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        Moderation warn;
        FPlayer fModerator;
        WarnModule module = (WarnModule)this.injector.getInstance(WarnModule.class);
        if (module.isModuleDisabledFor(fModerator = this.fPlayerService.getFPlayer((warn = (Moderation)this.gson.fromJson(input.readUTF(), Moderation.class)).getModerator()))) {
            return;
        }
        module.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.buildFormat(warn))).moderation(warn)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getCommand().getWarn().getDestination())).sound(module.getModuleSound())).build());
        module.send(fModerator, (FPlayer)fEntity, warn);
    }

    private void handleKickCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        Moderation kick;
        FPlayer fModerator;
        KickModule module = (KickModule)this.injector.getInstance(KickModule.class);
        if (module.isModuleDisabledFor(fModerator = this.fPlayerService.getFPlayer((kick = (Moderation)this.gson.fromJson(input.readUTF(), Moderation.class)).getModerator()))) {
            return;
        }
        module.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(module.buildFormat(kick))).moderation(kick)).destination(this.fileResolver.getCommand().getKick().getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
        module.kick(fModerator, (FPlayer)fEntity, kick);
    }

    private void handleTicTacToeCommand(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        if (!(fEntity instanceof FPlayer)) {
            return;
        }
        FPlayer fPlayer = (FPlayer)fEntity;
        TictactoeModule.GamePhase gamePhase = TictactoeModule.GamePhase.valueOf(input.readUTF());
        switch (gamePhase) {
            case CREATE: {
                FPlayer fReceiver = (FPlayer)this.gson.fromJson(input.readUTF(), FPlayer.class);
                int ticTacToeId = input.readInt();
                boolean isHard = input.readBoolean();
                TictactoeService tictactoeService = (TictactoeService)this.injector.getInstance(TictactoeService.class);
                TicTacToe ticTacToe = tictactoeService.get(ticTacToeId);
                if (tictactoeService.get(ticTacToeId) == null) {
                    ticTacToe = tictactoeService.create(ticTacToeId, fPlayer, fReceiver, isHard);
                }
                ((TictactoeModule)this.injector.getInstance(TictactoeModule.class)).sendCreateMessage(fPlayer, fReceiver, ticTacToe, metadataUUID);
                break;
            }
            case MOVE: {
                FPlayer fReceiver = (FPlayer)this.gson.fromJson(input.readUTF(), FPlayer.class);
                TicTacToe ticTacToe = ((TictactoeService)this.injector.getInstance(TictactoeService.class)).fromString(input.readUTF());
                int typeTitle = input.readInt();
                String move = input.readUTF();
                ((TictactoeModule)this.injector.getInstance(TictactoeModule.class)).sendMoveMessage(fPlayer, fReceiver, ticTacToe, typeTitle, move, metadataUUID);
            }
        }
    }

    private void handleChatMessage(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        String proxyChatName = input.readUTF();
        String message = input.readUTF();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(fEntity.getUuid());
        ChatModule chatModule = (ChatModule)this.injector.getInstance(ChatModule.class);
        if (chatModule.isModuleDisabledFor(fPlayer)) {
            return;
        }
        Optional<Map.Entry> optionalChat = this.fileResolver.getMessage().getChat().getTypes().entrySet().stream().filter(chat -> ((String)chat.getKey()).equals(proxyChatName)).findAny();
        if (optionalChat.isEmpty()) {
            return;
        }
        String chatName = (String)optionalChat.get().getKey();
        Message.Chat.Type chatType = (Message.Chat.Type)optionalChat.get().getValue();
        chatModule.sendMessage(((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)((ChatMetadata.ChatMetadataBuilder)ChatMetadata.builder().uuid(metadataUUID)).sender(fPlayer)).format(s -> s.getTypes().get(chatName))).chatName(chatName)).chatType(chatType)).range(Range.get(Range.Type.SERVER))).destination(chatType.getDestination())).message(message)).sound(chatModule.getModuleSound())).filter(chatModule.permissionFilter(chatName))).build());
    }

    private void handleClearchatCommand(FEntity fEntity) {
        ClearchatModule module = (ClearchatModule)this.injector.getInstance(ClearchatModule.class);
        if (!module.isEnable()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(fEntity.getUuid());
        module.clearChat(fPlayer, false);
    }

    private void handleRockPaperScissors(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        RockpaperscissorsModule.GamePhase gamePhase = RockpaperscissorsModule.GamePhase.valueOf(input.readUTF());
        switch (gamePhase) {
            case CREATE: {
                UUID id = UUID.fromString(input.readUTF());
                UUID receiver = UUID.fromString(input.readUTF());
                ((RockpaperscissorsModule)this.injector.getInstance(RockpaperscissorsModule.class)).create(id, fEntity, receiver);
                break;
            }
            case MOVE: {
                UUID id = UUID.fromString(input.readUTF());
                String move = input.readUTF();
                ((RockpaperscissorsModule)this.injector.getInstance(RockpaperscissorsModule.class)).move(id, fEntity, move, metadataUUID);
                break;
            }
            case END: {
                if (!(fEntity instanceof FPlayer)) {
                    return;
                }
                FPlayer fPlayer = (FPlayer)fEntity;
                UUID id = UUID.fromString(input.readUTF());
                String move = input.readUTF();
                ((RockpaperscissorsModule)this.injector.getInstance(RockpaperscissorsModule.class)).end(id, fPlayer, move, metadataUUID);
            }
        }
    }

    private void handleJoin(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        JoinModule module = (JoinModule)this.injector.getInstance(JoinModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        boolean hasPlayedBefore = input.readBoolean();
        boolean ignoreVanish = input.readBoolean();
        Message.Join message = this.fileResolver.getMessage().getJoin();
        module.sendMessage(((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((EventMetadata.EventMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)((JoinMetadata.JoinMetadataBuilder)JoinMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(s -> hasPlayedBefore || !message.isFirst() ? s.getFormat() : s.getFormatFirstTime())).ignoreVanish(ignoreVanish)).playedBefore(hasPlayedBefore)).destination(message.getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
    }

    private void handleQuit(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        QuitModule module = (QuitModule)this.injector.getInstance(QuitModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        boolean ignoreVanish = input.readBoolean();
        module.sendMessage(((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((EventMetadata.EventMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)((QuitMetadata.QuitMetadataBuilder)QuitMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(Localization.Message.Quit::getFormat)).ignoreVanish(ignoreVanish)).destination(this.fileResolver.getMessage().getQuit().getDestination())).range(Range.get(Range.Type.SERVER))).sound(module.getModuleSound())).build());
    }

    private void handleAfk(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        AfkModule module = (AfkModule)this.injector.getInstance(AfkModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        boolean isAfk = input.readBoolean();
        module.sendMessage(((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((EventMetadata.EventMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)((AFKMetadata.AFKMetadataBuilder)AFKMetadata.builder().uuid(metadataUUID)).sender(fEntity)).format(s -> isAfk ? s.getFormatFalse().getGlobal() : s.getFormatTrue().getGlobal())).newStatus(isAfk)).range(Range.get(Range.Type.SERVER))).destination(this.fileResolver.getMessage().getAfk().getDestination())).sound(module.getModuleSound())).build());
    }

    private void handleVanilla(DataInputStream input, FEntity fEntity, UUID metadataUUID) throws IOException {
        VanillaModule module = (VanillaModule)this.injector.getInstance(VanillaModule.class);
        if (module.isModuleDisabledFor(fEntity)) {
            return;
        }
        String translationKey = input.readUTF();
        Map<Integer, Object> arguments = this.parseVanillaArguments(this.readAsJsonObject(input));
        Message.Vanilla.VanillaMessage vanillaMessage = ((Extractor)this.injector.getInstance(Extractor.class)).getVanillaMessage(translationKey);
        ParsedComponent parsedComponent = new ParsedComponent(translationKey, vanillaMessage, arguments);
        String vanillaMessageName = vanillaMessage.getName();
        module.sendMessage(((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)((EventMetadata.EventMetadataBuilder)((VanillaMetadata.VanillaMetadataBuilder)VanillaMetadata.builder().uuid(metadataUUID)).parsedComponent(parsedComponent)).sender(fEntity)).format(localization -> StringUtils.defaultString((String)localization.getTypes().get(parsedComponent.translationKey())))).tagResolvers(fResolver -> module.tagResolvers((FPlayer)fResolver, parsedComponent))).range(Range.get(Range.Type.SERVER))).filter(fResolver -> vanillaMessageName.isEmpty() || fResolver.isSetting(vanillaMessageName))).destination(parsedComponent.vanillaMessage().getDestination())).build());
    }

    private Map<Integer, Object> parseVanillaArguments(JsonObject jsonObject) {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            Integer key = Integer.parseInt((String)entry.getKey());
            JsonObject argumentJson = ((JsonElement)entry.getValue()).getAsJsonObject();
            Optional<FEntity> entity = this.parseFEntity(argumentJson);
            result.put(key, entity.isPresent() ? entity.get() : this.gson.fromJson((JsonElement)argumentJson, Component.class));
        }
        return result;
    }

    private JsonObject readAsJsonObject(DataInputStream input) throws IOException {
        return (JsonObject)this.gson.fromJson(input.readUTF(), JsonObject.class);
    }

    private Optional<FEntity> parseFEntity(JsonObject jsonObject) {
        if (jsonObject.has("name") && jsonObject.has("uuid") && jsonObject.has("type")) {
            boolean isPlayer = "PLAYER".equals(jsonObject.get("type").getAsString());
            return Optional.of((FEntity)this.gson.fromJson((JsonElement)jsonObject, isPlayer ? FPlayer.class : FEntity.class));
        }
        return Optional.empty();
    }

    @Inject
    @Generated
    public ProxyMessageHandler(Injector injector, FileResolver fileResolver, FPlayerService fPlayerService, FLogger fLogger, ModerationService moderationService, Gson gson) {
        this.injector = injector;
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.fLogger = fLogger;
        this.moderationService = moderationService;
        this.gson = gson;
    }
}

