/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.provider;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.provider.AttributesProvider;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;

@Singleton
public class ModernAttributesProvider
implements AttributesProvider {
    @Override
    public double getArmorValue(Player player) {
        try {
            AttributeInstance instance = player.getAttribute(Attribute.GENERIC_ARMOR);
            return instance != null ? this.round(instance.getValue()) : 0.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public double getAttackDamage(Player player) {
        try {
            AttributeInstance instance = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
            return instance != null ? this.round(instance.getValue()) : 1.0;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private double round(double value) {
        return (double)Math.round(value * 10.0) / 10.0;
    }

    @Inject
    @Generated
    public ModernAttributesProvider() {
    }
}

