/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.provider;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.packetevents.PacketEvents;
import net.flectone.pulse.library.packetevents.PacketEventsAPI;
import net.flectone.pulse.library.packetevents.event.EventManager;
import net.flectone.pulse.library.packetevents.manager.player.PlayerManager;
import net.flectone.pulse.library.packetevents.manager.protocol.ProtocolManager;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.packetevents.protocol.player.ClientVersion;
import net.flectone.pulse.library.packetevents.protocol.player.User;
import net.flectone.pulse.model.entity.FPlayer;
import org.jetbrains.annotations.Nullable;

@Singleton
public class PacketProvider {
    private final PacketEventsAPI<?> api = PacketEvents.getAPI();

    public EventManager getEventManager() {
        return this.api.getEventManager();
    }

    public ProtocolManager getProtocolManager() {
        return this.api.getProtocolManager();
    }

    public PlayerManager getPlayerManager() {
        return this.api.getPlayerManager();
    }

    public Object getChannel(UUID uuid) {
        return this.getProtocolManager().getChannel(uuid);
    }

    public User getUser(UUID uuid) {
        Object channel = this.getChannel(uuid);
        if (channel == null) {
            return null;
        }
        return this.getProtocolManager().getUser(channel);
    }

    public User getUser(FPlayer fPlayer) {
        return this.getUser(fPlayer.getUuid());
    }

    public int getPing(Object player) {
        return this.getPlayerManager().getPing(player);
    }

    public ServerVersion getServerVersion() {
        return this.api.getServerManager().getVersion();
    }

    public boolean isNewerThanOrEquals(FPlayer fPlayer, ClientVersion clientVersion) {
        User user = this.getUser(fPlayer);
        if (user == null) {
            return false;
        }
        return user.getClientVersion().isNewerThanOrEquals(clientVersion);
    }

    @Nullable
    public String getHostAddress(@Nullable InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    @Inject
    @Generated
    public PacketProvider() {
    }
}

