/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.proxy;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.library.guava.collect.Iterables;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.BukkitProxyListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.platform.proxy.Proxy;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.Nullable;

@Singleton
public class BukkitProxy
implements Proxy {
    private final FileResolver fileResolver;
    private final Plugin plugin;
    private final Provider<BukkitProxyListener> proxyListenerProvider;
    private String channel;

    @Override
    public boolean isEnable() {
        return this.channel != null;
    }

    @Override
    public void onEnable() {
        this.channel = this.getChannel();
        if (this.channel == null) {
            return;
        }
        this.plugin.getServer().getMessenger().unregisterOutgoingPluginChannel(this.plugin);
        this.plugin.getServer().getMessenger().unregisterIncomingPluginChannel(this.plugin);
        this.plugin.getServer().getMessenger().registerOutgoingPluginChannel(this.plugin, this.channel);
        this.plugin.getServer().getMessenger().registerIncomingPluginChannel(this.plugin, this.channel, (PluginMessageListener)this.proxyListenerProvider.get());
    }

    @Override
    public void onDisable() {
        if (!this.isEnable()) {
            return;
        }
        this.plugin.getServer().getMessenger().unregisterOutgoingPluginChannel(this.plugin);
        this.plugin.getServer().getMessenger().unregisterIncomingPluginChannel(this.plugin);
        this.channel = null;
    }

    @Override
    public boolean sendMessage(FEntity sender, MessageType tag, byte[] message) {
        if (!this.isEnable()) {
            return false;
        }
        if (tag == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)sender.getUuid());
        if (player == null) {
            player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        }
        if (player == null) {
            return false;
        }
        player.sendPluginMessage(this.plugin, this.channel, message);
        return true;
    }

    @Nullable
    public String getChannel() {
        if (this.fileResolver.getConfig().getProxy().isBungeecord()) {
            return "BungeeCord";
        }
        if (this.fileResolver.getConfig().getProxy().isVelocity()) {
            return "flectonepulse:main";
        }
        return null;
    }

    @Inject
    @Generated
    public BukkitProxy(FileResolver fileResolver, Plugin plugin, Provider<BukkitProxyListener> proxyListenerProvider) {
        this.fileResolver = fileResolver;
        this.plugin = plugin;
        this.proxyListenerProvider = proxyListenerProvider;
    }
}

