/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.registry;

import java.util.function.Function;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.library.cloud.cloud.Command;
import net.flectone.pulse.library.cloud.cloud.CommandManager;
import net.flectone.pulse.library.cloud.cloud.SenderMapper;
import net.flectone.pulse.library.cloud.cloud.exception.ArgumentParseException;
import net.flectone.pulse.library.cloud.cloud.exception.CommandExecutionException;
import net.flectone.pulse.library.cloud.cloud.exception.InvalidSyntaxException;
import net.flectone.pulse.library.cloud.cloud.exception.NoPermissionException;
import net.flectone.pulse.library.cloud.cloud.execution.ExecutionCoordinator;
import net.flectone.pulse.library.cloud.cloud.paper.LegacyPaperCommandManager;
import net.flectone.pulse.library.cloud.cloud.setting.ManagerSetting;
import net.flectone.pulse.library.cloud.cloud.setting.Setting;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.platform.handler.CommandExceptionHandler;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.processing.mapper.FPlayerMapper;
import net.flectone.pulse.processing.resolver.FileResolver;
import org.bukkit.plugin.Plugin;

@Singleton
public class LegacyBukkitCommandRegistry
extends CommandRegistry {
    private final Config config;
    private final Plugin plugin;
    protected final LegacyPaperCommandManager<FPlayer> manager;

    @Inject
    public LegacyBukkitCommandRegistry(FileResolver fileResolver, CommandExceptionHandler commandExceptionHandler, Plugin plugin, FPlayerMapper fPlayerMapper) {
        this.config = fileResolver.getConfig();
        this.plugin = plugin;
        this.manager = new LegacyPaperCommandManager(plugin, ExecutionCoordinator.asyncCoordinator(), (SenderMapper)fPlayerMapper);
        this.manager.settings().set((Setting)ManagerSetting.ALLOW_UNSAFE_REGISTRATION, true);
        this.manager.exceptionController().registerHandler(ArgumentParseException.class, commandExceptionHandler::handleArgumentParseException);
        this.manager.exceptionController().registerHandler(InvalidSyntaxException.class, commandExceptionHandler::handleInvalidSyntaxException);
        this.manager.exceptionController().registerHandler(NoPermissionException.class, commandExceptionHandler::handleNoPermissionException);
        this.manager.exceptionController().registerHandler(CommandExecutionException.class, commandExceptionHandler::handleCommandExecutionException);
    }

    @Override
    public void registerCommand(Function<CommandManager<FPlayer>, Command.Builder<FPlayer>> builder) {
        boolean needUnregister;
        Command command = builder.apply((CommandManager<FPlayer>)this.manager).build();
        String commandName = command.rootComponent().name();
        boolean isCloudCommand = this.manager.commands().stream().anyMatch(fPlayerCommand -> fPlayerCommand.rootComponent().name().equals(commandName));
        boolean bl = needUnregister = this.plugin.getServer().getPluginCommand(commandName) != null || this.config.getCommand().isUnregisterOnReload() && isCloudCommand;
        if (needUnregister) {
            this.unregisterCommand(commandName);
        } else if (isCloudCommand) {
            return;
        }
        this.manager.command(command);
    }

    @Override
    public void unregisterCommand(String name) {
        this.manager.deleteRootCommand(name);
    }

    @Override
    public void reload() {
        if (!this.config.getCommand().isUnregisterOnReload()) {
            return;
        }
        this.syncRemoveCommands();
    }

    public void removeCommands() {
        this.manager.commands().stream().map(command -> command.rootComponent().name()).toList().forEach(this::unregisterCommand);
    }

    @Sync
    public void syncRemoveCommands() {
        this.removeCommands();
    }
}

