/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import com.google.gson.Gson;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.dto.MetricsDTO;

@Singleton
public class MetricsSender {
    private static final String FLECTONEPULSE_API_URL = "https://flectone.net/api/pulse/metrics";
    private final Gson gson;

    public void sendMetrics(MetricsDTO metrics) {
        try {
            String jsonData = this.gson.toJson((Object)metrics);
            URL url = new URI(FLECTONEPULSE_API_URL).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Length", String.valueOf(jsonData.getBytes(StandardCharsets.UTF_8).length));
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.setDoOutput(true);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            try (OutputStream os = connection.getOutputStream();
                 GZIPOutputStream gzipOS = new GZIPOutputStream(os);){
                gzipOS.write(jsonData.getBytes(StandardCharsets.UTF_8));
            }
            connection.disconnect();
            connection.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject
    @Generated
    public MetricsSender(Gson gson) {
        this.gson = gson;
    }
}

