/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.parser.player;

import lombok.NonNull;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.context.CommandInput;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.processing.parser.player.PlayerParser;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;

@Singleton
public class PlatformPlayerParser
extends PlayerParser {
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final IntegrationModule integrationModule;
    private final FPlayerService fPlayerService;

    @Inject
    public PlatformPlayerParser(FPlayerService fPlayerService, IntegrationModule integrationModule, FileResolver fileResolver, PlatformPlayerAdapter platformPlayerAdapter, PermissionChecker permissionChecker) {
        super(fPlayerService, integrationModule, fileResolver, platformPlayerAdapter, permissionChecker);
        this.fPlayerService = fPlayerService;
        this.integrationModule = integrationModule;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }

    @Override
    @NonNull
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.platformPlayerAdapter.getOnlinePlayers().stream().map(this.fPlayerService::getFPlayer).filter(player -> this.integrationModule.canSeeVanished((FEntity)player, (FEntity)context.sender())).filter(fPlayer -> this.isVisible((FPlayer)context.sender(), (FPlayer)fPlayer)).map(FEntity::getName).toList();
    }
}

