/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;
import net.flectone.pulse.library.libby.BukkitLibraryManager;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.library.libby.logging.adapters.LogAdapter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BukkitIgnoreSnapshotLibraryManager
extends BukkitLibraryManager {
    public BukkitIgnoreSnapshotLibraryManager(@NotNull Plugin plugin, @NotNull String directoryName, @NotNull LogAdapter logAdapter) {
        super(plugin, directoryName, logAdapter);
    }

    @Override
    @NotNull
    public Path downloadLibrary(@NotNull Library library) {
        Path file = this.saveDirectory.resolve(Objects.requireNonNull(library, "library").getPath());
        if (Files.exists(file, new LinkOption[0])) {
            if (library.hasRelocations()) {
                file = this.relocate(file, library.getRelocatedPath(), library.getRelocations());
            }
            return file;
        }
        Collection<String> urls = this.resolveLibrary(library);
        if (urls.isEmpty()) {
            throw new RuntimeException("Library '" + String.valueOf(library) + "' couldn't be resolved, add a repository");
        }
        MessageDigest md = null;
        if (library.hasChecksum()) {
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        Path out = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
        out.toFile().deleteOnExit();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            for (String url : urls) {
                byte[] checksum;
                byte[] bytes = this.downloadLibrary(url);
                if (bytes == null) continue;
                if (md != null && !Arrays.equals(checksum = md.digest(bytes), library.getChecksum())) {
                    this.logger.warn("*** INVALID CHECKSUM ***");
                    this.logger.warn(" Library :  " + String.valueOf(library));
                    this.logger.warn(" URL :  " + url);
                    this.logger.warn(" Expected :  " + Base64.getEncoder().encodeToString(library.getChecksum()));
                    this.logger.warn(" Actual :  " + Base64.getEncoder().encodeToString(checksum));
                    continue;
                }
                Files.write(out, bytes, new OpenOption[0]);
                Files.move(out, file, new CopyOption[0]);
                if (library.hasRelocations()) {
                    file = this.relocate(file, library.getRelocatedPath(), library.getRelocations());
                }
                Path path = file;
                return path;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                Files.deleteIfExists(out);
            }
            catch (IOException iOException) {}
        }
        throw new RuntimeException("Failed to download library '" + String.valueOf(library) + "'");
    }
}

