/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.processing.processor.YamlFileProcessor;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;
import net.flectone.pulse.util.creator.BackupCreator;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class FileResolver {
    private final Map<String, Localization> localizationMap = new HashMap<String, Localization>();
    private final Path projectPath;
    private final Command command;
    private final Config config;
    private final Integration integration;
    private final Message message;
    private final Permission permission;
    private final FLogger fLogger;
    private final YamlFileProcessor yamlFileProcessor;
    private final BackupCreator backupCreator;
    private String preInitVersion;
    private Localization defaultLocalization;

    @Inject
    public FileResolver(@Named(value="projectPath") Path projectPath, FLogger fLogger, YamlFileProcessor yamlFileProcessor, BackupCreator backupCreator) {
        this.projectPath = projectPath;
        this.command = new Command(projectPath);
        this.config = new Config(projectPath);
        this.integration = new Integration(projectPath);
        this.message = new Message(projectPath);
        this.permission = new Permission(projectPath);
        this.fLogger = fLogger;
        this.yamlFileProcessor = yamlFileProcessor;
        this.backupCreator = backupCreator;
    }

    public Localization getLocalization() {
        return this.getLocalization(FPlayer.UNKNOWN);
    }

    public Localization getLocalization(FEntity sender) {
        if (!this.config.getLanguage().isByPlayer()) {
            return this.defaultLocalization;
        }
        if (!(sender instanceof FPlayer)) {
            return this.defaultLocalization;
        }
        FPlayer fPlayer = (FPlayer)sender;
        return this.localizationMap.getOrDefault(fPlayer.getSetting(SettingText.LOCALE), this.defaultLocalization);
    }

    public void reload() throws IOException {
        boolean versionChanged;
        this.yamlFileProcessor.reload(this.config);
        this.loadLanguages();
        this.preInitVersion = this.config.getVersion();
        boolean bl = versionChanged = !this.preInitVersion.equals("1.6.2");
        if (versionChanged) {
            this.backupConfiguration();
        }
        this.reloadConfiguration();
        if (versionChanged) {
            if (this.isVersionOlderThan(this.preInitVersion, "1.4.3")) {
                this.migration_1_4_3();
            }
            if (this.isVersionOlderThan(this.preInitVersion, "1.5.0")) {
                this.migration_1_5_0();
            }
            if (this.isVersionOlderThan(this.preInitVersion, "1.6.0")) {
                this.migration_1_6_0();
            }
        }
        if (versionChanged) {
            this.config.setVersion("1.6.2");
            this.yamlFileProcessor.save(this.config);
        }
    }

    private void backupConfiguration() {
        this.backupCreator.setPreInitVersion(this.preInitVersion);
        this.backupCreator.backup(this.command);
        this.backupCreator.backup(this.integration);
        this.backupCreator.backup(this.message);
        this.backupCreator.backup(this.permission);
        for (Localization localization : this.localizationMap.values()) {
            this.backupCreator.backup(localization);
        }
    }

    private void reloadConfiguration() throws IOException {
        this.yamlFileProcessor.reload(this.command);
        this.yamlFileProcessor.reload(this.integration);
        this.yamlFileProcessor.reload(this.message);
        this.yamlFileProcessor.reload(this.permission);
        for (Localization localization : this.localizationMap.values()) {
            this.yamlFileProcessor.reload(localization);
        }
        this.defaultLocalization = this.localizationMap.get(this.config.getLanguage().getType());
    }

    public void save() throws IOException {
        this.yamlFileProcessor.save(this.command);
        this.yamlFileProcessor.save(this.config);
        this.yamlFileProcessor.save(this.integration);
        this.yamlFileProcessor.save(this.message);
        this.yamlFileProcessor.save(this.permission);
        for (Localization localization : this.localizationMap.values()) {
            this.yamlFileProcessor.save(localization);
        }
    }

    private void loadLanguages() {
        HashSet<String> newLanguages = new HashSet<String>(Set.of("ru_ru", "en_us"));
        newLanguages.add(this.config.getLanguage().getType());
        try (Stream<Path> paths2 = Files.walk(this.projectPath.resolve("localizations"), new FileVisitOption[0]);){
            paths2.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                File localization = path.toFile();
                String localizationName = localization.getName();
                if (localizationName.endsWith(".yml")) {
                    newLanguages.add(Strings.CS.replace(localizationName, ".yml", ""));
                }
            });
        }
        catch (NoSuchFileException paths2) {
        }
        catch (IOException e) {
            this.fLogger.warning(e);
        }
        for (String language : newLanguages) {
            this.loadLanguage(language);
        }
    }

    private void loadLanguage(String language) {
        Localization localization = new Localization(this.projectPath, language);
        this.localizationMap.put(language, localization);
    }

    public boolean isVersionOlderThan(String first, String second) {
        String[] subFirst = this.parseVersionNumbers(first);
        if (subFirst.length != 3) {
            return false;
        }
        String[] subSecond = this.parseVersionNumbers(second);
        if (subSecond.length != 3) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            int intSecond;
            int intFirst = Integer.parseInt(subFirst[i]);
            if (intFirst < (intSecond = Integer.parseInt(subSecond[i]))) {
                return true;
            }
            if (intFirst <= intSecond) continue;
            return false;
        }
        return false;
    }

    private String[] parseVersionNumbers(String string) {
        int endIndex = string.indexOf(45);
        return (endIndex == -1 ? string : string.substring(0, endIndex)).split("\\.");
    }

    private void migration_1_4_3() throws IOException {
        Permission.Message.Update update = this.permission.getMessage().getUpdate();
        if (update.getName().equals("flectonepulse.module.message.op")) {
            update.setName("flectonepulse.module.message.update");
            update.setSound(new Permission.PermissionEntry("flectonepulse.module.message.update.sound", Permission.Type.TRUE));
            this.yamlFileProcessor.save(this.permission);
        }
    }

    private void migration_1_5_0() throws IOException {
        Integration.Twitch twitch;
        Integration.Telegram telegram;
        String oldChatKey = "CHAT";
        String newChatKey = "CHAT_GLOBAL";
        Integration.Discord discord = this.integration.getDiscord();
        if (discord.getMessageChannel().containsKey(oldChatKey)) {
            discord.getMessageChannel().put(newChatKey, discord.getMessageChannel().remove(oldChatKey));
        }
        if ((telegram = this.integration.getTelegram()).getMessageChannel().containsKey(oldChatKey)) {
            telegram.getMessageChannel().put(newChatKey, telegram.getMessageChannel().remove(oldChatKey));
        }
        if ((twitch = this.integration.getTwitch()).getMessageChannel().containsKey(oldChatKey)) {
            twitch.getMessageChannel().put(newChatKey, twitch.getMessageChannel().remove(oldChatKey));
        }
        this.yamlFileProcessor.save(this.integration);
        for (Localization localization : this.localizationMap.values()) {
            Localization.Integration.Telegram localizationTelegram;
            Localization.Integration.Twitch localizationTwitch;
            Localization.Integration.Discord localizationDiscord = localization.getIntegration().getDiscord();
            if (localizationDiscord.getMessageChannel().containsKey(oldChatKey)) {
                localizationDiscord.getMessageChannel().put(newChatKey, localizationDiscord.getMessageChannel().remove(oldChatKey));
            }
            if ((localizationTwitch = localization.getIntegration().getTwitch()).getMessageChannel().containsKey(oldChatKey)) {
                localizationTwitch.getMessageChannel().put(newChatKey, localizationTwitch.getMessageChannel().remove(oldChatKey));
            }
            if ((localizationTelegram = localization.getIntegration().getTelegram()).getMessageChannel().containsKey(oldChatKey)) {
                localizationTelegram.getMessageChannel().put(newChatKey, localizationTelegram.getMessageChannel().remove(oldChatKey));
            }
            this.yamlFileProcessor.save(localization);
        }
    }

    private void migration_1_6_0() throws IOException {
        List<Command.Chatsetting.Menu.Color.Type> colorTypes = this.command.getChatsetting().getMenu().getSee().getTypes();
        for (Command.Chatsetting.Menu.Color.Type colorType : colorTypes) {
            if (!colorType.getName().equals("default")) continue;
            colorType.getColors().put(1, "");
            colorType.getColors().put(2, "");
        }
        Map<String, Integer> types = this.command.getChatsetting().getCheckbox().getTypes();
        HashMap<String, Integer> oldTypes = new HashMap<String, Integer>(types);
        types.clear();
        if (oldTypes.containsKey("AFK")) {
            types.put(MessageType.AFK.name(), 9);
        }
        if (oldTypes.containsKey("ADVANCEMENT")) {
            types.put(MessageType.ADVANCEMENT.name(), 10);
        }
        types.put(MessageType.CHAT.name(), 11);
        if (oldTypes.containsKey("ANON")) {
            types.put(MessageType.COMMAND_ANON.name(), 12);
        }
        if (oldTypes.containsKey("BALL")) {
            types.put(MessageType.COMMAND_BALL.name(), 13);
        }
        if (oldTypes.containsKey("BROADCAST")) {
            types.put(MessageType.COMMAND_BROADCAST.name(), 14);
        }
        if (oldTypes.containsKey("COIN")) {
            types.put(MessageType.COMMAND_COIN.name(), 15);
        }
        if (oldTypes.containsKey("DICE")) {
            types.put(MessageType.COMMAND_DICE.name(), 16);
        }
        if (oldTypes.containsKey("DO")) {
            types.put(MessageType.COMMAND_DO.name(), 17);
        }
        if (oldTypes.containsKey("MAIL")) {
            types.put(MessageType.COMMAND_MAIL.name(), 18);
        }
        if (oldTypes.containsKey("ME")) {
            types.put(MessageType.COMMAND_ME.name(), 19);
        }
        if (oldTypes.containsKey("POLL")) {
            types.put(MessageType.COMMAND_POLL.name(), 20);
        }
        if (oldTypes.containsKey("ROCKPAPERSCISSORS")) {
            types.put(MessageType.COMMAND_ROCKPAPERSCISSORS.name(), 21);
        }
        types.put(MessageType.COMMAND_STREAM.name(), 22);
        if (oldTypes.containsKey("TELL")) {
            types.put(MessageType.COMMAND_TELL.name(), 23);
        }
        if (oldTypes.containsKey("TICTACTOE")) {
            types.put(MessageType.COMMAND_TICTACTOE.name(), 24);
        }
        if (oldTypes.containsKey("TRY")) {
            types.put(MessageType.COMMAND_TRY.name(), 25);
        }
        if (oldTypes.containsKey("DEATH")) {
            types.put(MessageType.DEATH.name(), 26);
        }
        if (oldTypes.containsKey("DISCORD")) {
            types.put(MessageType.FROM_DISCORD_TO_MINECRAFT.name(), 27);
        }
        if (oldTypes.containsKey("TELEGRAM")) {
            types.put(MessageType.FROM_TELEGRAM_TO_MINECRAFT.name(), 28);
        }
        if (oldTypes.containsKey("TWITCH")) {
            types.put(MessageType.FROM_TWITCH_TO_MINECRAFT.name(), 29);
        }
        if (oldTypes.containsKey("JOIN")) {
            types.put(MessageType.JOIN.name(), 30);
        }
        if (oldTypes.containsKey("QUIT")) {
            types.put(MessageType.QUIT.name(), 31);
        }
        types.put(MessageType.SLEEP.name(), 32);
        this.yamlFileProcessor.save(this.command);
        Map<String, Permission.Command.Chatsetting.SettingItem> settings = this.permission.getCommand().getChatsetting().getSettings();
        settings.clear();
        settings.put(SettingText.CHAT_NAME.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.chat_name", Permission.Type.TRUE));
        settings.put("FCOLOR_" + FColor.Type.SEE.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.fcolor_see", Permission.Type.TRUE));
        settings.put("FCOLOR_" + FColor.Type.OUT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.fcolor_out", Permission.Type.OP));
        settings.put(MessageType.AFK.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.afk", Permission.Type.TRUE));
        settings.put(MessageType.ADVANCEMENT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.advancement", Permission.Type.TRUE));
        settings.put(MessageType.CHAT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.chat", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_ANON.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_anon", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_BALL.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_ball", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_BROADCAST.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_broadcast", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_COIN.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_coin", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_DICE.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_dice", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_DO.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_do", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_MAIL.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_mail", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_ME.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_me", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_POLL.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_poll", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_ROCKPAPERSCISSORS.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_rockpaperscissors", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_STREAM.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_stream", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_TELL.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_tell", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_TICTACTOE.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_tictactoe", Permission.Type.TRUE));
        settings.put(MessageType.COMMAND_TRY.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.command_try", Permission.Type.TRUE));
        settings.put(MessageType.DEATH.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.death", Permission.Type.TRUE));
        settings.put(MessageType.FROM_DISCORD_TO_MINECRAFT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.from_discord_to_minecraft", Permission.Type.TRUE));
        settings.put(MessageType.FROM_TELEGRAM_TO_MINECRAFT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.from_telegram_to_minecraft", Permission.Type.TRUE));
        settings.put(MessageType.FROM_TWITCH_TO_MINECRAFT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.from_twitch_to_minecraft", Permission.Type.TRUE));
        settings.put(MessageType.JOIN.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.join", Permission.Type.TRUE));
        settings.put(MessageType.QUIT.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.quit", Permission.Type.TRUE));
        settings.put(MessageType.SLEEP.name(), new Permission.Command.Chatsetting.SettingItem("flectonepulse.module.command.chatsetting.sleep", Permission.Type.TRUE));
        this.yamlFileProcessor.save(this.permission);
        for (Localization localization : this.localizationMap.values()) {
            Map<String, String> localizationTypes = localization.getCommand().getChatsetting().getCheckbox().getTypes();
            localizationTypes.clear();
            boolean isRussian = localization.getLanguage().toLowerCase().contains("ru");
            if (isRussian) {
                localizationTypes.put(MessageType.AFK.name(), "<status_color>\u0410\u0444\u043a");
                localizationTypes.put(MessageType.ADVANCEMENT.name(), "<status_color>\u0414\u043e\u0441\u0442\u0438\u0436\u0435\u043d\u0438\u044f");
                localizationTypes.put(MessageType.CHAT.name(), "<status_color>\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0447\u0430\u0442\u0430");
                localizationTypes.put(MessageType.COMMAND_ANON.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /anon");
                localizationTypes.put(MessageType.COMMAND_BALL.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /ball");
                localizationTypes.put(MessageType.COMMAND_BROADCAST.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /broadcast");
                localizationTypes.put(MessageType.COMMAND_COIN.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /coin");
                localizationTypes.put(MessageType.COMMAND_DICE.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /dice");
                localizationTypes.put(MessageType.COMMAND_DO.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /do");
                localizationTypes.put(MessageType.COMMAND_MAIL.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /mail");
                localizationTypes.put(MessageType.COMMAND_ME.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /me");
                localizationTypes.put(MessageType.COMMAND_POLL.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /poll");
                localizationTypes.put(MessageType.COMMAND_ROCKPAPERSCISSORS.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /rockpaperscissors");
                localizationTypes.put(MessageType.COMMAND_STREAM.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /stream");
                localizationTypes.put(MessageType.COMMAND_TELL.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /tell");
                localizationTypes.put(MessageType.COMMAND_TICTACTOE.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /tictactoe");
                localizationTypes.put(MessageType.COMMAND_TRY.name(), "<status_color>\u041a\u043e\u043c\u0430\u043d\u0434\u0430 /try");
                localizationTypes.put(MessageType.DEATH.name(), "<status_color>\u0421\u043c\u0435\u0440\u0442\u0438");
                localizationTypes.put(MessageType.FROM_DISCORD_TO_MINECRAFT.name(), "<status_color>\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0438\u0437 Discord");
                localizationTypes.put(MessageType.FROM_TELEGRAM_TO_MINECRAFT.name(), "<status_color>\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0438\u0437 Telegram");
                localizationTypes.put(MessageType.FROM_TWITCH_TO_MINECRAFT.name(), "<status_color>\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0438\u0437 Twitch");
                localizationTypes.put(MessageType.JOIN.name(), "<status_color>\u0412\u0445\u043e\u0434 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440");
                localizationTypes.put(MessageType.QUIT.name(), "<status_color>\u0412\u044b\u0445\u043e\u0434 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                localizationTypes.put(MessageType.SLEEP.name(), "<status_color>\u0421\u043e\u043d");
                Localization defaultRussianLocalization = new Localization(this.projectPath, "ru_ru");
                this.yamlFileProcessor.initLocalization(defaultRussianLocalization);
                localization.getCommand().setClearmail(defaultRussianLocalization.getCommand().getClearmail());
                localization.getCommand().setMail(defaultRussianLocalization.getCommand().getMail());
                localization.getCommand().setTell(defaultRussianLocalization.getCommand().getTell());
                localization.getCommand().setTictactoe(defaultRussianLocalization.getCommand().getTictactoe());
                localization.getCommand().setToponline(defaultRussianLocalization.getCommand().getToponline());
            } else {
                localizationTypes.put(MessageType.AFK.name(), "<status_color>Afk");
                localizationTypes.put(MessageType.ADVANCEMENT.name(), "<status_color>Advancement");
                localizationTypes.put(MessageType.CHAT.name(), "<status_color>Chat messages");
                localizationTypes.put(MessageType.COMMAND_ANON.name(), "<status_color>Command /anon");
                localizationTypes.put(MessageType.COMMAND_BALL.name(), "<status_color>Command /ball");
                localizationTypes.put(MessageType.COMMAND_BROADCAST.name(), "<status_color>Command /broadcast");
                localizationTypes.put(MessageType.COMMAND_COIN.name(), "<status_color>Command /coin");
                localizationTypes.put(MessageType.COMMAND_DICE.name(), "<status_color>Command /dice");
                localizationTypes.put(MessageType.COMMAND_DO.name(), "<status_color>Command /do");
                localizationTypes.put(MessageType.COMMAND_MAIL.name(), "<status_color>Command /mail");
                localizationTypes.put(MessageType.COMMAND_ME.name(), "<status_color>Command /me");
                localizationTypes.put(MessageType.COMMAND_POLL.name(), "<status_color>Command /poll");
                localizationTypes.put(MessageType.COMMAND_ROCKPAPERSCISSORS.name(), "<status_color>Command /rockpaperscissors");
                localizationTypes.put(MessageType.COMMAND_STREAM.name(), "<status_color>Command /stream");
                localizationTypes.put(MessageType.COMMAND_TELL.name(), "<status_color>Command /tell");
                localizationTypes.put(MessageType.COMMAND_TICTACTOE.name(), "<status_color>Command /tictactoe");
                localizationTypes.put(MessageType.COMMAND_TRY.name(), "<status_color>Command /try");
                localizationTypes.put(MessageType.DEATH.name(), "<status_color>Death");
                localizationTypes.put(MessageType.FROM_DISCORD_TO_MINECRAFT.name(), "<status_color>Messages from Discord");
                localizationTypes.put(MessageType.FROM_TELEGRAM_TO_MINECRAFT.name(), "<status_color>Messages from Telegram");
                localizationTypes.put(MessageType.FROM_TWITCH_TO_MINECRAFT.name(), "<status_color>Messages from Twitch");
                localizationTypes.put(MessageType.JOIN.name(), "<status_color>Join");
                localizationTypes.put(MessageType.QUIT.name(), "<status_color>Quit");
                localizationTypes.put(MessageType.SLEEP.name(), "<status_color>Sleep");
                Localization defaultEnglishLocalization = new Localization(this.projectPath, "en_us");
                this.yamlFileProcessor.initLocalization(defaultEnglishLocalization);
                localization.getCommand().setClearmail(defaultEnglishLocalization.getCommand().getClearmail());
                localization.getCommand().setMail(defaultEnglishLocalization.getCommand().getMail());
                localization.getCommand().setTell(defaultEnglishLocalization.getCommand().getTell());
                localization.getCommand().setTictactoe(defaultEnglishLocalization.getCommand().getTictactoe());
                localization.getCommand().setToponline(defaultEnglishLocalization.getCommand().getToponline());
            }
            this.yamlFileProcessor.save(localization);
        }
    }

    @Generated
    public Map<String, Localization> getLocalizationMap() {
        return this.localizationMap;
    }

    @Generated
    public Path getProjectPath() {
        return this.projectPath;
    }

    @Generated
    public Command getCommand() {
        return this.command;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public Integration getIntegration() {
        return this.integration;
    }

    @Generated
    public Message getMessage() {
        return this.message;
    }

    @Generated
    public Permission getPermission() {
        return this.permission;
    }

    @Generated
    public FLogger getFLogger() {
        return this.fLogger;
    }

    @Generated
    public YamlFileProcessor getYamlFileProcessor() {
        return this.yamlFileProcessor;
    }

    @Generated
    public BackupCreator getBackupCreator() {
        return this.backupCreator;
    }

    @Generated
    public String getPreInitVersion() {
        return this.preInitVersion;
    }

    @Generated
    public Localization getDefaultLocalization() {
        return this.defaultLocalization;
    }
}

