/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import java.time.Instant;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.dto.MetricsDTO;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.controller.ModuleController;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.MetricsSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import xyz.wagyourtail.jvmdg.version.Ref;
import xyz.wagyourtail.jvmdg.version.Stub;

@Singleton
public class MetricsService {
    private final TaskScheduler taskScheduler;
    private final MetricsSender metricsSender;
    private final PlatformServerAdapter platformServerAdapter;
    private final PacketProvider packetProvider;
    private final FileResolver fileResolver;
    private final ModuleController moduleController;

    public void reload() {
        this.taskScheduler.runAsyncTimer(this::send, 0L, 72000L);
    }

    public void send() {
        MetricsDTO metricsDTO = new MetricsDTO();
        metricsDTO.setServerUUID(this.platformServerAdapter.getServerUUID());
        metricsDTO.setServerCore(this.platformServerAdapter.getServerCore());
        metricsDTO.setServerVersion(this.packetProvider.getServerVersion().getReleaseName());
        metricsDTO.setOsName(this.getOsName());
        metricsDTO.setOsArchitecture(this.getOsArch());
        metricsDTO.setOsVersion(this.getOsVersion());
        metricsDTO.setJavaVersion(this.getJavaVersion());
        metricsDTO.setCpuCores(Runtime.getRuntime().availableProcessors());
        metricsDTO.setTotalRAM(Runtime.getRuntime().maxMemory());
        Config config = this.fileResolver.getConfig();
        metricsDTO.setProjectVersion(config.getVersion());
        metricsDTO.setProjectLanguage(config.getLanguage().getType());
        metricsDTO.setOnlineMode(this.platformServerAdapter.isOnlineMode() ? "True" : "False");
        metricsDTO.setProxyMode(this.getProxyMode());
        metricsDTO.setDatabaseMode(config.getDatabase().getType().name());
        metricsDTO.setPlayerCount(this.platformServerAdapter.getOnlinePlayerCount());
        metricsDTO.setModules(this.moduleController.collectModuleStatuses());
        metricsDTO.setCreatedAt(Instant.now().toString());
        this.metricsSender.sendMetrics(metricsDTO);
    }

    private String getProxyMode() {
        Config.Proxy config = this.fileResolver.getConfig().getProxy();
        if (config.isBungeecord()) {
            return "BungeeCord";
        }
        if (config.isVelocity()) {
            return "Velocity";
        }
        if (config.getRedis().isEnable()) {
            return "Redis";
        }
        return "None";
    }

    private String getOsName() {
        return MetricsService.jvmdg$inlined$getProperty("os.name");
    }

    private String getOsArch() {
        return MetricsService.jvmdg$inlined$getProperty("os.arch");
    }

    private String getOsVersion() {
        return MetricsService.jvmdg$inlined$getProperty("os.version");
    }

    private String getJavaVersion() {
        return MetricsService.jvmdg$inlined$getProperty("java.version");
    }

    @Inject
    @Generated
    public MetricsService(TaskScheduler taskScheduler, MetricsSender metricsSender, PlatformServerAdapter platformServerAdapter, PacketProvider packetProvider, FileResolver fileResolver, ModuleController moduleController) {
        this.taskScheduler = taskScheduler;
        this.metricsSender = metricsSender;
        this.platformServerAdapter = platformServerAdapter;
        this.packetProvider = packetProvider;
        this.fileResolver = fileResolver;
        this.moduleController = moduleController;
    }

    @Stub(ref=@Ref(value="java/lang/System"))
    private static /* synthetic */ String jvmdg$inlined$getProperty(String key) {
        if (key.equals("native.encoding")) {
            String prop = System.getProperty(key);
            if (prop != null) {
                return prop;
            }
            return System.getProperty("file.encoding");
        }
        return System.getProperty(key);
    }
}

